/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain.consent;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.consent.AccountAccessType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

@ApiModel(description="Account access", value="AccountAccess")
public final class AccountAccess {
    @ApiModelProperty(value="detailed account information", required=false)
    private final List<AccountReference> accounts;
    @ApiModelProperty(value="balances of the addressed accounts", required=false)
    private final List<AccountReference> balances;
    @ApiModelProperty(value="transactions of the addressed accounts", required=false)
    private final List<AccountReference> transactions;
    @ApiModelProperty(value="only the value 'all-accounts' is admitted", example="all-accounts", required=false)
    private final AccountAccessType availableAccounts;
    @ApiModelProperty(value="only the value 'all-accounts' is admitted", example="all-accounts", required=false)
    private final AccountAccessType allPsd2;

    @JsonIgnore
    public boolean isNotEmpty() {
        return !CollectionUtils.isEmpty((Collection)this.accounts) || !CollectionUtils.isEmpty((Collection)this.balances) || !CollectionUtils.isEmpty((Collection)this.transactions) || this.allPsd2 != null || this.availableAccounts != null;
    }

    @ConstructorProperties(value={"accounts", "balances", "transactions", "availableAccounts", "allPsd2"})
    public AccountAccess(List<AccountReference> accounts, List<AccountReference> balances, List<AccountReference> transactions, AccountAccessType availableAccounts, AccountAccessType allPsd2) {
        this.accounts = accounts;
        this.balances = balances;
        this.transactions = transactions;
        this.availableAccounts = availableAccounts;
        this.allPsd2 = allPsd2;
    }

    public List<AccountReference> getAccounts() {
        return this.accounts;
    }

    public List<AccountReference> getBalances() {
        return this.balances;
    }

    public List<AccountReference> getTransactions() {
        return this.transactions;
    }

    public AccountAccessType getAvailableAccounts() {
        return this.availableAccounts;
    }

    public AccountAccessType getAllPsd2() {
        return this.allPsd2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountAccess)) {
            return false;
        }
        AccountAccess other = (AccountAccess)o;
        List this$accounts = this.getAccounts();
        List other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        List this$balances = this.getBalances();
        List other$balances = other.getBalances();
        if (this$balances == null ? other$balances != null : !((Object)this$balances).equals(other$balances)) {
            return false;
        }
        List this$transactions = this.getTransactions();
        List other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
            return false;
        }
        AccountAccessType this$availableAccounts = this.getAvailableAccounts();
        AccountAccessType other$availableAccounts = other.getAvailableAccounts();
        if (this$availableAccounts == null ? other$availableAccounts != null : !this$availableAccounts.equals(other$availableAccounts)) {
            return false;
        }
        AccountAccessType this$allPsd2 = this.getAllPsd2();
        AccountAccessType other$allPsd2 = other.getAllPsd2();
        return !(this$allPsd2 == null ? other$allPsd2 != null : !this$allPsd2.equals(other$allPsd2));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        List $balances = this.getBalances();
        result = result * 59 + ($balances == null ? 43 : ((Object)$balances).hashCode());
        List $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        AccountAccessType $availableAccounts = this.getAvailableAccounts();
        result = result * 59 + ($availableAccounts == null ? 43 : $availableAccounts.hashCode());
        AccountAccessType $allPsd2 = this.getAllPsd2();
        result = result * 59 + ($allPsd2 == null ? 43 : $allPsd2.hashCode());
        return result;
    }

    public String toString() {
        return "AccountAccess(accounts=" + this.getAccounts() + ", balances=" + this.getBalances() + ", transactions=" + this.getTransactions() + ", availableAccounts=" + this.getAvailableAccounts() + ", allPsd2=" + this.getAllPsd2() + ")";
    }
}

