/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain.account;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Currency;
import java.util.Optional;

@ApiModel(description="Account Reference", value="AccountReference")
public class AccountReference {
    @ApiModelProperty(value="IBAN: This data element can be used in the body of the CreateConsentReq Request Message for retrieving account access consent from this payment account", required=false, example="DE371234599999")
    private String iban;
    @ApiModelProperty(value="BBAN: This data elements is used for payment accounts which have no IBAN", example="1111111111")
    private String bban;
    @ApiModelProperty(value="PAN: Primary Account Number (PAN) of a card, can be tokenized by the ASPSP due to PCI DSS requirements.", example="1111")
    private String pan;
    @ApiModelProperty(value="MASKEDPAN: Primary Account Number (PAN) of a card in a masked form.", example="23456xxxxxx1234")
    private String maskedPan;
    @ApiModelProperty(value="MSISDN: An alias to access a payment account via a registered mobile phone number. This alias might be needed e.g. in the payment initiation service, cp. Section 5.3.1. The support of this alias must be explicitly documented by the ASPSP for the corresponding API calls.", example="0172/1111111")
    private String msisdn;
    @ApiModelProperty(value="Codes following ISO 4217", example="EUR")
    private Currency currency;

    @JsonIgnore
    public boolean matches(AccountReference otherReference) {
        return Optional.ofNullable(otherReference.getCurrency()).map(cur -> this.iban.equals(otherReference.getIban()) && this.currency == cur).orElse(this.iban.equals(otherReference.getIban()));
    }

    public String getIban() {
        return this.iban;
    }

    public String getBban() {
        return this.bban;
    }

    public String getPan() {
        return this.pan;
    }

    public String getMaskedPan() {
        return this.maskedPan;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public void setBban(String bban) {
        this.bban = bban;
    }

    public void setPan(String pan) {
        this.pan = pan;
    }

    public void setMaskedPan(String maskedPan) {
        this.maskedPan = maskedPan;
    }

    public void setMsisdn(String msisdn) {
        this.msisdn = msisdn;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountReference)) {
            return false;
        }
        AccountReference other = (AccountReference)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$iban = this.getIban();
        String other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
            return false;
        }
        String this$bban = this.getBban();
        String other$bban = other.getBban();
        if (this$bban == null ? other$bban != null : !this$bban.equals(other$bban)) {
            return false;
        }
        String this$pan = this.getPan();
        String other$pan = other.getPan();
        if (this$pan == null ? other$pan != null : !this$pan.equals(other$pan)) {
            return false;
        }
        String this$maskedPan = this.getMaskedPan();
        String other$maskedPan = other.getMaskedPan();
        if (this$maskedPan == null ? other$maskedPan != null : !this$maskedPan.equals(other$maskedPan)) {
            return false;
        }
        String this$msisdn = this.getMsisdn();
        String other$msisdn = other.getMsisdn();
        if (this$msisdn == null ? other$msisdn != null : !this$msisdn.equals(other$msisdn)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $iban = this.getIban();
        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
        String $bban = this.getBban();
        result = result * 59 + ($bban == null ? 43 : $bban.hashCode());
        String $pan = this.getPan();
        result = result * 59 + ($pan == null ? 43 : $pan.hashCode());
        String $maskedPan = this.getMaskedPan();
        result = result * 59 + ($maskedPan == null ? 43 : $maskedPan.hashCode());
        String $msisdn = this.getMsisdn();
        result = result * 59 + ($msisdn == null ? 43 : $msisdn.hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        return result;
    }

    public String toString() {
        return "AccountReference(iban=" + this.getIban() + ", bban=" + this.getBban() + ", pan=" + this.getPan() + ", maskedPan=" + this.getMaskedPan() + ", msisdn=" + this.getMsisdn() + ", currency=" + this.getCurrency() + ")";
    }
}

