/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.aspsp.xs2a.domain.Balances;
import de.adorsys.aspsp.xs2a.domain.CashAccountType;
import de.adorsys.aspsp.xs2a.domain.Links;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.Currency;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@ApiModel(description="SpiAccountDetails information", value="SpiAccountDetails")
public class AccountDetails {
    @ApiModelProperty(value="ID: This is the data element to be used in the path when retrieving data from a dedicated account", required=true, example="3dc3d5b3-7023-4848-9853-f5400a64e80f")
    @Size(max=35)
    @NotNull
    private final @Size(max=35) @NotNull String id;
    @ApiModelProperty(value="IBAN: This data element can be used in the body of the CreateConsentReq Request Message for retrieving account access consent from this payment accoun", example="DE2310010010123456789")
    private final String iban;
    @ApiModelProperty(value="BBAN: This data element can be used in the body of the CreateConsentReq Request Message for retrieving account access consent from this account, for payment accounts which have no IBAN. ", example="DE2310010010123456789")
    private final String bban;
    @ApiModelProperty(value="PAN: Primary Account Number (PAN) of a card, can be tokenized by the ASPSP due to PCI DSS requirements", example="1111222233334444")
    @Size(max=35)
    private final @Size(max=35) String pan;
    @ApiModelProperty(value="MSISDN: An alias to access a payment account via a registered mobile phone number.", example="111122xxxxxx4444")
    @Size(max=35)
    private final @Size(max=35) String maskedPan;
    @ApiModelProperty(value="MSISDN: An alias to access a payment account via a registered mobile phone number.", example="49057543010")
    @Size(max=35)
    private final @Size(max=35) String msisdn;
    @ApiModelProperty(value="Currency Type", required=true, example="EUR")
    @NotNull
    private final Currency currency;
    @ApiModelProperty(value="Name: Name given by the bank or the Psu in Online- Banking", example="Main Account")
    private final String name;
    @ApiModelProperty(value="Account Type: Product Name of the Bank for this account", example="Girokonto")
    @Size(max=35)
    private final @Size(max=35) String accountType;
    @ApiModelProperty(value="Cash Account Type: PExternalCashAccountType1Code from ISO20022")
    private final CashAccountType cashAccountType;
    @ApiModelProperty(value="BIC: The BIC associated to the account.", example="EDEKDEHHXXX")
    private final String bic;
    @ApiModelProperty(value="Balances")
    private final List<Balances> balances;
    @ApiModelProperty(value="links: inks to the account, which can be directly used for retrieving account information from the dedicated account")
    @JsonProperty(value="_links")
    private Links links = new Links();

    @ConstructorProperties(value={"id", "iban", "bban", "pan", "maskedPan", "msisdn", "currency", "name", "accountType", "cashAccountType", "bic", "balances"})
    public AccountDetails(String id, String iban, String bban, String pan, String maskedPan, String msisdn, Currency currency, String name, String accountType, CashAccountType cashAccountType, String bic, List<Balances> balances) {
        this.id = id;
        this.iban = iban;
        this.bban = bban;
        this.pan = pan;
        this.maskedPan = maskedPan;
        this.msisdn = msisdn;
        this.currency = currency;
        this.name = name;
        this.accountType = accountType;
        this.cashAccountType = cashAccountType;
        this.bic = bic;
        this.balances = balances;
    }

    public String getId() {
        return this.id;
    }

    public String getIban() {
        return this.iban;
    }

    public String getBban() {
        return this.bban;
    }

    public String getPan() {
        return this.pan;
    }

    public String getMaskedPan() {
        return this.maskedPan;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getName() {
        return this.name;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public CashAccountType getCashAccountType() {
        return this.cashAccountType;
    }

    public String getBic() {
        return this.bic;
    }

    public List<Balances> getBalances() {
        return this.balances;
    }

    public Links getLinks() {
        return this.links;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountDetails)) {
            return false;
        }
        AccountDetails other = (AccountDetails)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$iban = this.getIban();
        String other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
            return false;
        }
        String this$bban = this.getBban();
        String other$bban = other.getBban();
        if (this$bban == null ? other$bban != null : !this$bban.equals(other$bban)) {
            return false;
        }
        String this$pan = this.getPan();
        String other$pan = other.getPan();
        if (this$pan == null ? other$pan != null : !this$pan.equals(other$pan)) {
            return false;
        }
        String this$maskedPan = this.getMaskedPan();
        String other$maskedPan = other.getMaskedPan();
        if (this$maskedPan == null ? other$maskedPan != null : !this$maskedPan.equals(other$maskedPan)) {
            return false;
        }
        String this$msisdn = this.getMsisdn();
        String other$msisdn = other.getMsisdn();
        if (this$msisdn == null ? other$msisdn != null : !this$msisdn.equals(other$msisdn)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$accountType = this.getAccountType();
        String other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
            return false;
        }
        CashAccountType this$cashAccountType = this.getCashAccountType();
        CashAccountType other$cashAccountType = other.getCashAccountType();
        if (this$cashAccountType == null ? other$cashAccountType != null : !this$cashAccountType.equals(other$cashAccountType)) {
            return false;
        }
        String this$bic = this.getBic();
        String other$bic = other.getBic();
        if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
            return false;
        }
        List this$balances = this.getBalances();
        List other$balances = other.getBalances();
        if (this$balances == null ? other$balances != null : !((Object)this$balances).equals(other$balances)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !this$links.equals(other$links));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $iban = this.getIban();
        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
        String $bban = this.getBban();
        result = result * 59 + ($bban == null ? 43 : $bban.hashCode());
        String $pan = this.getPan();
        result = result * 59 + ($pan == null ? 43 : $pan.hashCode());
        String $maskedPan = this.getMaskedPan();
        result = result * 59 + ($maskedPan == null ? 43 : $maskedPan.hashCode());
        String $msisdn = this.getMsisdn();
        result = result * 59 + ($msisdn == null ? 43 : $msisdn.hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
        CashAccountType $cashAccountType = this.getCashAccountType();
        result = result * 59 + ($cashAccountType == null ? 43 : $cashAccountType.hashCode());
        String $bic = this.getBic();
        result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
        List $balances = this.getBalances();
        result = result * 59 + ($balances == null ? 43 : ((Object)$balances).hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : $links.hashCode());
        return result;
    }

    public String toString() {
        return "AccountDetails(id=" + this.getId() + ", iban=" + this.getIban() + ", bban=" + this.getBban() + ", pan=" + this.getPan() + ", maskedPan=" + this.getMaskedPan() + ", msisdn=" + this.getMsisdn() + ", currency=" + this.getCurrency() + ", name=" + this.getName() + ", accountType=" + this.getAccountType() + ", cashAccountType=" + this.getCashAccountType() + ", bic=" + this.getBic() + ", balances=" + this.getBalances() + ", links=" + this.getLinks() + ")";
    }
}

