/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.adorsys.aspsp.xs2a.domain.Amount;
import de.adorsys.aspsp.xs2a.domain.account.AccountReference;
import de.adorsys.aspsp.xs2a.domain.code.BankTransactionCode;
import de.adorsys.aspsp.xs2a.domain.code.PurposeCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import javax.validation.constraints.Size;

@ApiModel(description="TransactionsCreditorResponse information", value="TransactionsCreditorResponse")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Transactions {
    @ApiModelProperty(value="Can be used as access-ID in the API, where more details on an transaction is offered.", required=false, example="1234567")
    @Size(max=35)
    private @Size(max=35) String transactionId;
    @ApiModelProperty(value="End to end id", required=false, example="123456789")
    @Size(max=35)
    private @Size(max=35) String endToEndId;
    @ApiModelProperty(value="Identification of Mandates, e.g. a SEPA Mandate ID", required=false, example="12345")
    @Size(max=35)
    private @Size(max=35) String mandateId;
    @ApiModelProperty(value="Identification of Creditors, e.g. a SEPA Creditor ID", required=false, example="12345")
    @Size(max=35)
    private @Size(max=35) String creditorId;
    @ApiModelProperty(value="Booking Date", example="2017-01-01")
    private LocalDate bookingDate;
    @ApiModelProperty(value="Value Date", example="2017-01-01")
    private LocalDate valueDate;
    @ApiModelProperty(value="Amount", required=true)
    private Amount amount;
    @ApiModelProperty(value="Name of the Creditor if a debited transaction", example="John Miles")
    @Size(max=70)
    private @Size(max=70) String creditorName;
    @ApiModelProperty(value="Creditor account")
    private AccountReference creditorAccount;
    @ApiModelProperty(value="Name of the last creditor", example="Paul Simpson")
    @Size(max=70)
    private @Size(max=70) String ultimateCreditor;
    @ApiModelProperty(value="Name of the debtor if a \u201cCredited\u201d transaction", example="Jan")
    private String debtorName;
    @ApiModelProperty(value="Debtor account")
    private AccountReference debtorAccount;
    @ApiModelProperty(value="Name of the last debtor", example="Max")
    @Size(max=70)
    private @Size(max=70) String ultimateDebtor;
    @ApiModelProperty(value="Remittance information unstructured", example="Ref Number Merchant")
    @Size(max=140)
    private @Size(max=140) String remittanceInformationUnstructured;
    @ApiModelProperty(value="Remittance information structured;", example="Ref Number Merchant")
    @Size(max=140)
    private @Size(max=140) String remittanceInformationStructured;
    @ApiModelProperty(value="Purpose code")
    private PurposeCode purposeCode;
    @ApiModelProperty(value="Bank transaction code as used by the ASPSP in ISO20022 related formats.")
    private BankTransactionCode bankTransactionCodeCode;

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getEndToEndId() {
        return this.endToEndId;
    }

    public String getMandateId() {
        return this.mandateId;
    }

    public String getCreditorId() {
        return this.creditorId;
    }

    public LocalDate getBookingDate() {
        return this.bookingDate;
    }

    public LocalDate getValueDate() {
        return this.valueDate;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public String getCreditorName() {
        return this.creditorName;
    }

    public AccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public String getUltimateCreditor() {
        return this.ultimateCreditor;
    }

    public String getDebtorName() {
        return this.debtorName;
    }

    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public String getUltimateDebtor() {
        return this.ultimateDebtor;
    }

    public String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    public String getRemittanceInformationStructured() {
        return this.remittanceInformationStructured;
    }

    public PurposeCode getPurposeCode() {
        return this.purposeCode;
    }

    public BankTransactionCode getBankTransactionCodeCode() {
        return this.bankTransactionCodeCode;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setEndToEndId(String endToEndId) {
        this.endToEndId = endToEndId;
    }

    public void setMandateId(String mandateId) {
        this.mandateId = mandateId;
    }

    public void setCreditorId(String creditorId) {
        this.creditorId = creditorId;
    }

    public void setBookingDate(LocalDate bookingDate) {
        this.bookingDate = bookingDate;
    }

    public void setValueDate(LocalDate valueDate) {
        this.valueDate = valueDate;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public void setCreditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public void setUltimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
    }

    public void setDebtorName(String debtorName) {
        this.debtorName = debtorName;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public void setUltimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    public void setRemittanceInformationStructured(String remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
    }

    public void setPurposeCode(PurposeCode purposeCode) {
        this.purposeCode = purposeCode;
    }

    public void setBankTransactionCodeCode(BankTransactionCode bankTransactionCodeCode) {
        this.bankTransactionCodeCode = bankTransactionCodeCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transactions)) {
            return false;
        }
        Transactions other = (Transactions)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$endToEndId = this.getEndToEndId();
        String other$endToEndId = other.getEndToEndId();
        if (this$endToEndId == null ? other$endToEndId != null : !this$endToEndId.equals(other$endToEndId)) {
            return false;
        }
        String this$mandateId = this.getMandateId();
        String other$mandateId = other.getMandateId();
        if (this$mandateId == null ? other$mandateId != null : !this$mandateId.equals(other$mandateId)) {
            return false;
        }
        String this$creditorId = this.getCreditorId();
        String other$creditorId = other.getCreditorId();
        if (this$creditorId == null ? other$creditorId != null : !this$creditorId.equals(other$creditorId)) {
            return false;
        }
        LocalDate this$bookingDate = this.getBookingDate();
        LocalDate other$bookingDate = other.getBookingDate();
        if (this$bookingDate == null ? other$bookingDate != null : !((Object)this$bookingDate).equals(other$bookingDate)) {
            return false;
        }
        LocalDate this$valueDate = this.getValueDate();
        LocalDate other$valueDate = other.getValueDate();
        if (this$valueDate == null ? other$valueDate != null : !((Object)this$valueDate).equals(other$valueDate)) {
            return false;
        }
        Amount this$amount = this.getAmount();
        Amount other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        String this$creditorName = this.getCreditorName();
        String other$creditorName = other.getCreditorName();
        if (this$creditorName == null ? other$creditorName != null : !this$creditorName.equals(other$creditorName)) {
            return false;
        }
        AccountReference this$creditorAccount = this.getCreditorAccount();
        AccountReference other$creditorAccount = other.getCreditorAccount();
        if (this$creditorAccount == null ? other$creditorAccount != null : !this$creditorAccount.equals(other$creditorAccount)) {
            return false;
        }
        String this$ultimateCreditor = this.getUltimateCreditor();
        String other$ultimateCreditor = other.getUltimateCreditor();
        if (this$ultimateCreditor == null ? other$ultimateCreditor != null : !this$ultimateCreditor.equals(other$ultimateCreditor)) {
            return false;
        }
        String this$debtorName = this.getDebtorName();
        String other$debtorName = other.getDebtorName();
        if (this$debtorName == null ? other$debtorName != null : !this$debtorName.equals(other$debtorName)) {
            return false;
        }
        AccountReference this$debtorAccount = this.getDebtorAccount();
        AccountReference other$debtorAccount = other.getDebtorAccount();
        if (this$debtorAccount == null ? other$debtorAccount != null : !this$debtorAccount.equals(other$debtorAccount)) {
            return false;
        }
        String this$ultimateDebtor = this.getUltimateDebtor();
        String other$ultimateDebtor = other.getUltimateDebtor();
        if (this$ultimateDebtor == null ? other$ultimateDebtor != null : !this$ultimateDebtor.equals(other$ultimateDebtor)) {
            return false;
        }
        String this$remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        String other$remittanceInformationUnstructured = other.getRemittanceInformationUnstructured();
        if (this$remittanceInformationUnstructured == null ? other$remittanceInformationUnstructured != null : !this$remittanceInformationUnstructured.equals(other$remittanceInformationUnstructured)) {
            return false;
        }
        String this$remittanceInformationStructured = this.getRemittanceInformationStructured();
        String other$remittanceInformationStructured = other.getRemittanceInformationStructured();
        if (this$remittanceInformationStructured == null ? other$remittanceInformationStructured != null : !this$remittanceInformationStructured.equals(other$remittanceInformationStructured)) {
            return false;
        }
        PurposeCode this$purposeCode = this.getPurposeCode();
        PurposeCode other$purposeCode = other.getPurposeCode();
        if (this$purposeCode == null ? other$purposeCode != null : !this$purposeCode.equals(other$purposeCode)) {
            return false;
        }
        BankTransactionCode this$bankTransactionCodeCode = this.getBankTransactionCodeCode();
        BankTransactionCode other$bankTransactionCodeCode = other.getBankTransactionCodeCode();
        return !(this$bankTransactionCodeCode == null ? other$bankTransactionCodeCode != null : !this$bankTransactionCodeCode.equals(other$bankTransactionCodeCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Transactions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $endToEndId = this.getEndToEndId();
        result = result * 59 + ($endToEndId == null ? 43 : $endToEndId.hashCode());
        String $mandateId = this.getMandateId();
        result = result * 59 + ($mandateId == null ? 43 : $mandateId.hashCode());
        String $creditorId = this.getCreditorId();
        result = result * 59 + ($creditorId == null ? 43 : $creditorId.hashCode());
        LocalDate $bookingDate = this.getBookingDate();
        result = result * 59 + ($bookingDate == null ? 43 : ((Object)$bookingDate).hashCode());
        LocalDate $valueDate = this.getValueDate();
        result = result * 59 + ($valueDate == null ? 43 : ((Object)$valueDate).hashCode());
        Amount $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        String $creditorName = this.getCreditorName();
        result = result * 59 + ($creditorName == null ? 43 : $creditorName.hashCode());
        AccountReference $creditorAccount = this.getCreditorAccount();
        result = result * 59 + ($creditorAccount == null ? 43 : $creditorAccount.hashCode());
        String $ultimateCreditor = this.getUltimateCreditor();
        result = result * 59 + ($ultimateCreditor == null ? 43 : $ultimateCreditor.hashCode());
        String $debtorName = this.getDebtorName();
        result = result * 59 + ($debtorName == null ? 43 : $debtorName.hashCode());
        AccountReference $debtorAccount = this.getDebtorAccount();
        result = result * 59 + ($debtorAccount == null ? 43 : $debtorAccount.hashCode());
        String $ultimateDebtor = this.getUltimateDebtor();
        result = result * 59 + ($ultimateDebtor == null ? 43 : $ultimateDebtor.hashCode());
        String $remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        result = result * 59 + ($remittanceInformationUnstructured == null ? 43 : $remittanceInformationUnstructured.hashCode());
        String $remittanceInformationStructured = this.getRemittanceInformationStructured();
        result = result * 59 + ($remittanceInformationStructured == null ? 43 : $remittanceInformationStructured.hashCode());
        PurposeCode $purposeCode = this.getPurposeCode();
        result = result * 59 + ($purposeCode == null ? 43 : $purposeCode.hashCode());
        BankTransactionCode $bankTransactionCodeCode = this.getBankTransactionCodeCode();
        result = result * 59 + ($bankTransactionCodeCode == null ? 43 : $bankTransactionCodeCode.hashCode());
        return result;
    }

    public String toString() {
        return "Transactions(transactionId=" + this.getTransactionId() + ", endToEndId=" + this.getEndToEndId() + ", mandateId=" + this.getMandateId() + ", creditorId=" + this.getCreditorId() + ", bookingDate=" + this.getBookingDate() + ", valueDate=" + this.getValueDate() + ", amount=" + this.getAmount() + ", creditorName=" + this.getCreditorName() + ", creditorAccount=" + this.getCreditorAccount() + ", ultimateCreditor=" + this.getUltimateCreditor() + ", debtorName=" + this.getDebtorName() + ", debtorAccount=" + this.getDebtorAccount() + ", ultimateDebtor=" + this.getUltimateDebtor() + ", remittanceInformationUnstructured=" + this.getRemittanceInformationUnstructured() + ", remittanceInformationStructured=" + this.getRemittanceInformationStructured() + ", purposeCode=" + this.getPurposeCode() + ", bankTransactionCodeCode=" + this.getBankTransactionCodeCode() + ")";
    }
}

