/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.adorsys.aspsp.xs2a.domain.MessageErrorCode;
import de.adorsys.aspsp.xs2a.exception.MessageCategory;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Size;

@ApiModel(description="Tpp Message Information", value="TppMessageInformation")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TppMessageInformation {
    @ApiModelProperty(value="Category of the error, Only \u201dERROR\u201d or \"WARNING\" permitted", required=true, example="Error")
    private MessageCategory category;
    @ApiModelProperty(value="Code", required=true)
    private MessageErrorCode code;
    @ApiModelProperty(value="Path")
    private String path;
    @ApiModelProperty(value="Additional explanation text", example="Additional text information of the ASPSP up to 512 characters")
    @Size(max=512)
    private @Size(max=512) String text;

    public TppMessageInformation(MessageCategory category, MessageErrorCode code) {
        this.category = category;
        this.code = code;
    }

    public TppMessageInformation path(String path) {
        this.path = path;
        return this;
    }

    public TppMessageInformation text(String text) {
        this.text = text;
        return this;
    }

    public MessageCategory getCategory() {
        return this.category;
    }

    public MessageErrorCode getCode() {
        return this.code;
    }

    public String getPath() {
        return this.path;
    }

    public String getText() {
        return this.text;
    }

    public void setCategory(MessageCategory category) {
        this.category = category;
    }

    public void setCode(MessageErrorCode code) {
        this.code = code;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TppMessageInformation)) {
            return false;
        }
        TppMessageInformation other = (TppMessageInformation)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        MessageCategory this$category = this.getCategory();
        MessageCategory other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        MessageErrorCode this$code = this.getCode();
        MessageErrorCode other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TppMessageInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MessageCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        MessageErrorCode $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    public String toString() {
        return "TppMessageInformation(category=" + this.getCategory() + ", code=" + this.getCode() + ", path=" + this.getPath() + ", text=" + this.getText() + ")";
    }
}

