/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.config.rest.aspsp;

import de.adorsys.aspsp.xs2a.config.rest.BearerToken;
import de.adorsys.aspsp.xs2a.config.rest.BearerTokenInterceptor;
import de.adorsys.aspsp.xs2a.config.rest.aspsp.AspspRestErrorHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration
@Profile(value={"mockspi"})
public class AspspRestConfig {
    @Value(value="${http-client.read-timeout.ms:10000}")
    private int readTimeout;
    @Value(value="${http-client.connection-timeout.ms:10000}")
    private int connectionTimeout;
    @Autowired
    private BearerToken bearerToken;

    @Bean(name={"aspspRestTemplate"})
    @Scope(scopeName="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public RestTemplate restTemplate() {
        RestTemplate rest = new RestTemplate(this.clientHttpRequestFactory());
        rest.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        rest.getMessageConverters().add(new StringHttpMessageConverter());
        rest.getInterceptors().add(new BearerTokenInterceptor(this.bearerToken.getToken()));
        rest.setErrorHandler((ResponseErrorHandler)new AspspRestErrorHandler());
        return rest;
    }

    private ClientHttpRequestFactory clientHttpRequestFactory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(this.readTimeout);
        factory.setConnectTimeout(this.connectionTimeout);
        return factory;
    }
}

