/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import de.adorsys.aspsp.xs2a.config.KeycloakConfigProperties;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.AuthorizationCodeGrantBuilder;
import springfox.documentation.builders.OAuthBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.AuthorizationCodeGrant;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.OAuth;
import springfox.documentation.service.TokenEndpoint;
import springfox.documentation.service.TokenRequestEndpoint;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.SecurityConfiguration;
import springfox.documentation.swagger.web.SecurityConfigurationBuilder;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfig {
    @Value(value="${license.url}")
    private String licenseUrl;
    @Autowired
    private KeycloakConfigProperties keycloakConfig;

    @Bean(name={"api"})
    public Docket apiDocklet() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.getApiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)"de.adorsys.aspsp.xs2a.web")).paths(Predicates.not((Predicate)PathSelectors.regex((String)"/error.*?"))).paths(Predicates.not((Predicate)PathSelectors.regex((String)"/connect.*"))).paths(Predicates.not((Predicate)PathSelectors.regex((String)"/management.*"))).build().securitySchemes(Collections.singletonList(this.securitySchema()));
    }

    private ApiInfo getApiInfo() {
        return new ApiInfoBuilder().title("XS2A REST API").contact(new Contact("adorsys GmbH & Co. KG", "http://www.github.com/adorsys/xs2a", "fpo@adorsys.de")).version("1.0").license("Apache License 2.0").licenseUrl(this.licenseUrl).build();
    }

    private OAuth securitySchema() {
        AuthorizationCodeGrant grantType = new AuthorizationCodeGrantBuilder().tokenEndpoint(new TokenEndpoint(this.keycloakConfig.getRootPath() + "/protocol/openid-connect/token", "oauthtoken")).tokenRequestEndpoint(new TokenRequestEndpoint(this.keycloakConfig.getRootPath() + "/protocol/openid-connect/auth", this.keycloakConfig.getResource(), this.keycloakConfig.getCredentials().getSecret())).build();
        return new OAuthBuilder().name("oauth2").grantTypes(Collections.singletonList(grantType)).scopes(this.scopes()).build();
    }

    private List<AuthorizationScope> scopes() {
        return Collections.singletonList(new AuthorizationScope("read", "Access read API"));
    }

    @Bean
    public SecurityConfiguration security() {
        return SecurityConfigurationBuilder.builder().clientId(this.keycloakConfig.getResource()).clientSecret(this.keycloakConfig.getCredentials().getSecret()).realm(this.keycloakConfig.getRealm()).appName(this.keycloakConfig.getResource()).scopeSeparator(",").useBasicAuthenticationWithAccessCodeGrant(Boolean.valueOf(false)).build();
    }
}

