/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl;

import de.adorsys.aspsp.xs2a.spi.config.AspspRemoteUrls;
import de.adorsys.aspsp.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiSinglePayments;
import de.adorsys.aspsp.xs2a.spi.service.PaymentSpi;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class PaymentSpiImpl
implements PaymentSpi {
    private final AspspRemoteUrls aspspRemoteUrls;
    @Qualifier(value="aspspRestTemplate")
    private final RestTemplate aspspRestTemplate;

    public SpiPaymentInitialisationResponse createPaymentInitiation(SpiSinglePayments spiSinglePayments, String paymentProduct, boolean tppRedirectPreferred) {
        ResponseEntity responseEntity = this.aspspRestTemplate.postForEntity(this.aspspRemoteUrls.createPayment(), (Object)spiSinglePayments, SpiSinglePayments.class, new Object[0]);
        return responseEntity.getStatusCode() == HttpStatus.CREATED ? this.mapToSpiPaymentResponse((SpiSinglePayments)responseEntity.getBody(), tppRedirectPreferred) : null;
    }

    public List<SpiPaymentInitialisationResponse> createBulkPayments(List<SpiSinglePayments> payments, String paymentProduct, boolean tppRedirectPreferred) {
        ResponseEntity responseEntity = this.aspspRestTemplate.exchange(this.aspspRemoteUrls.createBulkPayment(), HttpMethod.POST, new HttpEntity(payments, null), (ParameterizedTypeReference)new ParameterizedTypeReference<List<SpiSinglePayments>>(){}, new Object[0]);
        return responseEntity.getStatusCode() == HttpStatus.CREATED ? ((List)responseEntity.getBody()).stream().map(spiPaym -> this.mapToSpiPaymentResponse((SpiSinglePayments)spiPaym, tppRedirectPreferred)).collect(Collectors.toList()) : Collections.emptyList();
    }

    public SpiPaymentInitialisationResponse initiatePeriodicPayment(SpiPeriodicPayment periodicPayment, String paymentProduct, boolean tppRedirectPreferred) {
        ResponseEntity responseEntity = this.aspspRestTemplate.postForEntity(this.aspspRemoteUrls.createPeriodicPayment(), (Object)periodicPayment, SpiPeriodicPayment.class, new Object[0]);
        return responseEntity.getStatusCode() == HttpStatus.CREATED ? this.mapToSpiPaymentResponse((SpiSinglePayments)responseEntity.getBody(), tppRedirectPreferred) : null;
    }

    public SpiTransactionStatus getPaymentStatusById(String paymentId, String paymentProduct) {
        return (SpiTransactionStatus)this.aspspRestTemplate.getForEntity(this.aspspRemoteUrls.getPaymentStatus(), SpiTransactionStatus.class, new Object[]{paymentId}).getBody();
    }

    private SpiPaymentInitialisationResponse mapToSpiPaymentResponse(SpiSinglePayments spiSinglePayments, boolean tppRedirectPreferred) {
        SpiPaymentInitialisationResponse paymentResponse = new SpiPaymentInitialisationResponse();
        paymentResponse.setTransactionStatus(SpiTransactionStatus.RCVD);
        paymentResponse.setPaymentId(spiSinglePayments.getPaymentId());
        paymentResponse.setTppRedirectPreferred(tppRedirectPreferred);
        return paymentResponse;
    }

    @ConstructorProperties(value={"aspspRemoteUrls", "aspspRestTemplate"})
    public PaymentSpiImpl(AspspRemoteUrls aspspRemoteUrls, RestTemplate aspspRestTemplate) {
        this.aspspRemoteUrls = aspspRemoteUrls;
        this.aspspRestTemplate = aspspRestTemplate;
    }
}

