/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl;

import de.adorsys.aspsp.xs2a.spi.config.AspspRemoteUrls;
import de.adorsys.aspsp.xs2a.spi.domain.ObjectHolder;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiBalances;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.aspsp.xs2a.spi.service.AccountSpi;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@Profile(value={"mockspi"})
public class AccountSpiImpl
implements AccountSpi {
    private final AspspRemoteUrls remoteSpiUrls;
    @Qualifier(value="aspspRestTemplate")
    private final RestTemplate aspspRestTemplate;

    public List<SpiAccountDetails> readAccountDetailsByIban(String iban) {
        return Optional.ofNullable(this.aspspRestTemplate.exchange(this.remoteSpiUrls.getAccountDetailsByIban(), HttpMethod.GET, new HttpEntity(null), (ParameterizedTypeReference)new ParameterizedTypeReference<List<SpiAccountDetails>>(){}, new Object[]{iban}).getBody()).orElse(Collections.emptyList());
    }

    public List<SpiBalances> readBalances(String accountId) {
        return Optional.ofNullable(this.aspspRestTemplate.exchange(this.remoteSpiUrls.getBalancesByAccountId(), HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<SpiBalances>>(){}, new Object[]{accountId}).getBody()).orElse(Collections.emptyList());
    }

    public String saveTransaction(SpiTransaction transaction) {
        return (String)this.aspspRestTemplate.postForEntity(this.remoteSpiUrls.createTransaction(), (Object)transaction, String.class, new Object[0]).getBody();
    }

    public List<SpiTransaction> readTransactionsByPeriod(String accountId, LocalDate dateFrom, LocalDate dateTo) {
        Map uriParams = new ObjectHolder().addValue((Object)"account-id", (Object)accountId).getValues();
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.remoteSpiUrls.readTransactionsByPeriod()).queryParam("dateFrom", new Object[]{dateFrom}).queryParam("dateTo", new Object[]{dateTo});
        return (List)this.aspspRestTemplate.exchange(builder.buildAndExpand(uriParams).toUriString(), HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<SpiTransaction>>(){}, new Object[0]).getBody();
    }

    public Optional<SpiTransaction> readTransactionById(String transactionId, String accountId) {
        return Optional.ofNullable(this.aspspRestTemplate.getForObject(this.remoteSpiUrls.readTransactionById(), SpiTransaction.class, new Object[]{transactionId, accountId}));
    }

    public SpiAccountDetails readAccountDetails(String accountId) {
        return (SpiAccountDetails)this.aspspRestTemplate.getForObject(this.remoteSpiUrls.getAccountDetailsById(), SpiAccountDetails.class, new Object[]{accountId});
    }

    public List<SpiAccountDetails> readAccountsByPsuId(String psuId) {
        return Optional.ofNullable(this.aspspRestTemplate.exchange(this.remoteSpiUrls.getAccountDetailsByPsuId(), HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<SpiAccountDetails>>(){}, new Object[]{psuId}).getBody()).orElse(Collections.emptyList());
    }

    public List<SpiAccountDetails> readAccountDetailsByIbans(Collection<String> ibans) {
        ArrayList<SpiAccountDetails> accountDetails = new ArrayList<SpiAccountDetails>();
        for (String iban : ibans) {
            List<SpiAccountDetails> det = this.readAccountDetailsByIban(iban);
            if (CollectionUtils.isEmpty(det)) {
                return Collections.emptyList();
            }
            accountDetails.addAll(det);
        }
        return accountDetails;
    }

    public List<String> readPsuAllowedPaymentProductList(SpiAccountReference reference) {
        return Optional.ofNullable(this.aspspRestTemplate.exchange(this.remoteSpiUrls.getAllowedPaymentProducts(), HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<String>>(){}, new Object[]{reference.getIban()}).getBody()).orElse(Collections.emptyList());
    }

    @ConstructorProperties(value={"remoteSpiUrls", "aspspRestTemplate"})
    public AccountSpiImpl(AspspRemoteUrls remoteSpiUrls, RestTemplate aspspRestTemplate) {
        this.remoteSpiUrls = remoteSpiUrls;
        this.aspspRestTemplate = aspspRestTemplate;
    }
}

