/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AspspRemoteUrls {
    @Value(value="${mockspi.baseurl:http://localhost:28080}")
    private String spiMockBaseUrl;

    public String getAccountDetailsById() {
        return this.spiMockBaseUrl + "/account/{account-id}";
    }

    public String getBalancesByAccountId() {
        return this.spiMockBaseUrl + "/account/{account-id}/balances";
    }

    public String getAccountDetailsByPsuId() {
        return this.spiMockBaseUrl + "/account/psu/{psu-id}";
    }

    public String getAccountDetailsByIban() {
        return this.spiMockBaseUrl + "/account/iban/{iban}";
    }

    public String createPayment() {
        return this.spiMockBaseUrl + "/payments/";
    }

    public String getPaymentStatus() {
        return this.spiMockBaseUrl + "/payments/{payment-id}/status";
    }

    public String createBulkPayment() {
        return this.spiMockBaseUrl + "/payments/bulk-payments";
    }

    public String createPeriodicPayment() {
        return this.spiMockBaseUrl + "/payments/create-periodic-payment";
    }

    public String readTransactionById() {
        return this.spiMockBaseUrl + "/transaction/{transaction-id}/{account-id}";
    }

    public String readTransactionsByPeriod() {
        return this.spiMockBaseUrl + "/transaction/{account-id}";
    }

    public String createTransaction() {
        return this.spiMockBaseUrl + "/transaction";
    }

    public String getAllowedPaymentProducts() {
        return this.spiMockBaseUrl + "/psu/allowed-payment-products/{iban}";
    }
}

