/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.mapper;

import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.core.profile.PaymentProduct;
import de.adorsys.psd2.xs2a.spi.domain.code.SpiFrequencyCode;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPeriodicPaymentInitiationResponse;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class SpiPeriodicPaymentMapper {
    public SpiPeriodicPayment mapToAspspSpiPeriodicPayment(@NotNull de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment payment, SpiTransactionStatus transactionStatus) {
        SpiPeriodicPayment periodic = new SpiPeriodicPayment();
        periodic.setPaymentId(payment.getPaymentId());
        periodic.setEndToEndIdentification(payment.getEndToEndIdentification());
        periodic.setDebtorAccount(payment.getDebtorAccount());
        periodic.setInstructedAmount(payment.getInstructedAmount());
        periodic.setCreditorAccount(payment.getCreditorAccount());
        periodic.setCreditorAgent(payment.getCreditorAgent());
        periodic.setCreditorName(payment.getCreditorName());
        periodic.setCreditorAddress(payment.getCreditorAddress());
        periodic.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        periodic.setPaymentStatus(transactionStatus);
        periodic.setStartDate(payment.getStartDate());
        periodic.setEndDate(payment.getEndDate());
        periodic.setExecutionRule(payment.getExecutionRule());
        periodic.setFrequency(payment.getFrequency().name());
        periodic.setDayOfExecution(payment.getDayOfExecution());
        return periodic;
    }

    public de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment mapToSpiPeriodicPayment(@NotNull SpiPeriodicPayment payment, PaymentProduct paymentProduct) {
        de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment periodic = new de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment(paymentProduct);
        periodic.setPaymentId(payment.getPaymentId());
        periodic.setEndToEndIdentification(payment.getEndToEndIdentification());
        periodic.setDebtorAccount(payment.getDebtorAccount());
        periodic.setInstructedAmount(payment.getInstructedAmount());
        periodic.setCreditorAccount(payment.getCreditorAccount());
        periodic.setCreditorAgent(payment.getCreditorAgent());
        periodic.setCreditorName(payment.getCreditorName());
        periodic.setCreditorAddress(payment.getCreditorAddress());
        periodic.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        periodic.setPaymentStatus(payment.getPaymentStatus());
        periodic.setStartDate(payment.getStartDate());
        periodic.setEndDate(payment.getEndDate());
        periodic.setExecutionRule(payment.getExecutionRule());
        periodic.setFrequency(SpiFrequencyCode.valueOf((String)payment.getFrequency()));
        periodic.setDayOfExecution(payment.getDayOfExecution());
        return periodic;
    }

    public SpiPeriodicPaymentInitiationResponse mapToSpiPeriodicPaymentResponse(@NotNull SpiPeriodicPayment payment) {
        SpiPeriodicPaymentInitiationResponse spi = new SpiPeriodicPaymentInitiationResponse();
        spi.setPaymentId(payment.getPaymentId());
        if (payment.getPaymentId() == null) {
            spi.setTransactionStatus(SpiTransactionStatus.RJCT);
        } else {
            spi.setTransactionStatus(SpiTransactionStatus.RCVD);
        }
        return spi;
    }
}

