/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.mapper;

import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.aspsp.xs2a.spi.mapper.SpiSinglePaymentMapper;
import de.adorsys.psd2.xs2a.core.profile.PaymentProduct;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiBulkPaymentInitiationResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class SpiBulkPaymentMapper {
    private final SpiSinglePaymentMapper spiSinglePaymentMapper;

    public SpiBulkPayment mapToAspspSpiBulkPayment(@NotNull de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment payment, SpiTransactionStatus transactionStatus) {
        SpiBulkPayment bulk = new SpiBulkPayment();
        bulk.setDebtorAccount(payment.getDebtorAccount());
        bulk.setBatchBookingPreferred(payment.getBatchBookingPreferred());
        bulk.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        bulk.setPayments(this.mapToListAspspSpiSinglePayment(payment, transactionStatus));
        bulk.setPaymentStatus(transactionStatus);
        return bulk;
    }

    public SpiBulkPaymentInitiationResponse mapToSpiBulkPaymentResponse(@NotNull SpiBulkPayment payment, PaymentProduct paymentProduct) {
        SpiBulkPaymentInitiationResponse spi = new SpiBulkPaymentInitiationResponse();
        spi.setPayments(this.mapToListSpiSinglePayments(payment.getPayments(), paymentProduct));
        spi.setPaymentId(payment.getPaymentId());
        if (payment.getPaymentId() == null) {
            spi.setTransactionStatus(SpiTransactionStatus.RJCT);
        } else {
            spi.setTransactionStatus(SpiTransactionStatus.RCVD);
        }
        return spi;
    }

    public de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment mapToSpiBulkPayment(@NotNull List<SpiSinglePayment> payments, PaymentProduct paymentProduct) {
        de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment bulk = new de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment();
        bulk.setPayments(this.mapToListSpiSinglePayments(payments, paymentProduct));
        bulk.setPaymentStatus(payments.get(0).getPaymentStatus());
        return bulk;
    }

    private List<SpiSinglePayment> mapToListAspspSpiSinglePayment(@NotNull de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment payment, SpiTransactionStatus transactionStatus) {
        return payment.getPayments().stream().map(p -> this.spiSinglePaymentMapper.mapToAspspSpiSinglePayment(p, transactionStatus)).collect(Collectors.toList());
    }

    private List<de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment> mapToListSpiSinglePayments(@NotNull List<SpiSinglePayment> payments, PaymentProduct paymentProduct) {
        return payments.stream().map(p -> this.spiSinglePaymentMapper.mapToSpiSinglePayment(p, paymentProduct)).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"spiSinglePaymentMapper"})
    public SpiBulkPaymentMapper(SpiSinglePaymentMapper spiSinglePaymentMapper) {
        this.spiSinglePaymentMapper = spiSinglePaymentMapper;
    }
}

