/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl;

import de.adorsys.aspsp.xs2a.service.mapper.consent.SpiCmsPisMapper;
import de.adorsys.aspsp.xs2a.spi.component.SpiMockJsonConverter;
import de.adorsys.aspsp.xs2a.spi.config.rest.AspspRemoteUrls;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPaymentInitialisationResponse;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.aspsp.xs2a.spi.impl.service.KeycloakInvokerService;
import de.adorsys.aspsp.xs2a.spi.mapper.SpiPaymentMapper;
import de.adorsys.aspsp.xs2a.spi.service.PaymentSpi;
import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.profile.PaymentProduct;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaMethod;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class PaymentSpiImpl
implements PaymentSpi {
    private final AspspRemoteUrls aspspRemoteUrls;
    @Qualifier(value="aspspRestTemplate")
    private final RestTemplate aspspRestTemplate;
    private final KeycloakInvokerService keycloakInvokerService;
    private final SpiMockJsonConverter jsonConverter;
    private final SpiPaymentMapper spiPaymentMapper;
    private final SpiCmsPisMapper spiCmsPisMapper;

    public SpiResponse<SpiPaymentInitialisationResponse> createPaymentInitiation(SpiSinglePayment spiSinglePayment, AspspConsentData aspspConsentData) {
        ResponseEntity responseEntity = this.aspspRestTemplate.postForEntity(this.aspspRemoteUrls.createPayment(), (Object)spiSinglePayment, SpiSinglePayment.class, new Object[0]);
        SpiPaymentInitialisationResponse response = responseEntity.getStatusCode() == HttpStatus.CREATED ? this.spiPaymentMapper.mapToSpiPaymentResponse((SpiSinglePayment)responseEntity.getBody()) : this.spiPaymentMapper.mapToSpiPaymentResponse(spiSinglePayment);
        return new SpiResponse((Object)response, aspspConsentData);
    }

    public SpiResponse<List<SpiPaymentInitialisationResponse>> createBulkPayments(SpiBulkPayment spiBulkPayment, AspspConsentData aspspConsentData) {
        ResponseEntity responseEntity = this.aspspRestTemplate.exchange(this.aspspRemoteUrls.createBulkPayment(), HttpMethod.POST, new HttpEntity((Object)spiBulkPayment, null), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        List response = responseEntity.getStatusCode() == HttpStatus.CREATED ? ((List)responseEntity.getBody()).stream().map(arg_0 -> ((SpiPaymentMapper)this.spiPaymentMapper).mapToSpiPaymentResponse(arg_0)).collect(Collectors.toList()) : Collections.emptyList();
        return new SpiResponse(response, aspspConsentData);
    }

    public SpiResponse<SpiPaymentInitialisationResponse> initiatePeriodicPayment(SpiPeriodicPayment periodicPayment, AspspConsentData aspspConsentData) {
        ResponseEntity responseEntity = this.aspspRestTemplate.postForEntity(this.aspspRemoteUrls.createPeriodicPayment(), (Object)periodicPayment, SpiPeriodicPayment.class, new Object[0]);
        SpiPaymentInitialisationResponse response = responseEntity.getStatusCode() == HttpStatus.CREATED ? this.spiPaymentMapper.mapToSpiPaymentResponse((SpiSinglePayment)responseEntity.getBody()) : this.spiPaymentMapper.mapToSpiPaymentResponse((SpiSinglePayment)periodicPayment);
        return new SpiResponse((Object)response, aspspConsentData);
    }

    public SpiResponse<SpiTransactionStatus> getPaymentStatusById(String paymentId, PaymentType paymentType, AspspConsentData aspspConsentData) {
        SpiTransactionStatus response = (SpiTransactionStatus)this.aspspRestTemplate.getForEntity(this.aspspRemoteUrls.getPaymentStatus(), SpiTransactionStatus.class, new Object[]{paymentId}).getBody();
        return new SpiResponse((Object)response, aspspConsentData);
    }

    public SpiResponse<SpiSinglePayment> getSinglePaymentById(PaymentType paymentType, PaymentProduct paymentProduct, String paymentId, AspspConsentData aspspConsentData) {
        List aspspResponse = (List)this.aspspRestTemplate.exchange(this.aspspRemoteUrls.getPaymentById(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{paymentType, paymentProduct, paymentId}).getBody();
        SpiSinglePayment response = (SpiSinglePayment)aspspResponse.get(0);
        return new SpiResponse((Object)response, aspspConsentData);
    }

    public SpiResponse<SpiPeriodicPayment> getPeriodicPaymentById(PaymentType paymentType, PaymentProduct paymentProduct, String paymentId, AspspConsentData aspspConsentData) {
        List aspspResponse = (List)this.aspspRestTemplate.exchange(this.aspspRemoteUrls.getPaymentById(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{paymentType, paymentProduct, paymentId}).getBody();
        SpiPeriodicPayment response = (SpiPeriodicPayment)aspspResponse.get(0);
        return new SpiResponse((Object)response, aspspConsentData);
    }

    public SpiResponse<List<SpiSinglePayment>> getBulkPaymentById(PaymentType paymentType, PaymentProduct paymentProduct, String paymentId, AspspConsentData aspspConsentData) {
        List aspspResponse = (List)this.aspspRestTemplate.exchange(this.aspspRemoteUrls.getPaymentById(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{paymentType, paymentProduct, paymentId}).getBody();
        return new SpiResponse((Object)aspspResponse, aspspConsentData);
    }

    public SpiResponse<SpiAuthorisationStatus> authorisePsu(String psuId, String password, AspspConsentData aspspConsentData) {
        Optional accessToken = this.keycloakInvokerService.obtainAuthorisationData(psuId, password);
        SpiAuthorisationStatus spiAuthorisationStatus = accessToken.map(t -> SpiAuthorisationStatus.SUCCESS).orElse(SpiAuthorisationStatus.FAILURE);
        byte[] payload = accessToken.flatMap(arg_0 -> ((SpiMockJsonConverter)this.jsonConverter).toJson(arg_0)).map(String::getBytes).orElse(null);
        return new SpiResponse((Object)spiAuthorisationStatus, aspspConsentData.respondWith(payload));
    }

    public SpiResponse<List<SpiScaMethod>> readAvailableScaMethod(String psuId, AspspConsentData aspspConsentData) {
        ResponseEntity response = this.aspspRestTemplate.exchange(this.aspspRemoteUrls.getScaMethods(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{psuId});
        List spiScaMethods = Optional.ofNullable(response.getBody()).orElseGet(Collections::emptyList);
        return new SpiResponse((Object)spiScaMethods, aspspConsentData);
    }

    public SpiResponse<String> executePayment(PaymentType paymentType, List<PisPayment> payments, AspspConsentData aspspConsentData) {
        String paymentId;
        if (PaymentType.SINGLE == paymentType) {
            SpiPaymentInitialisationResponse paymentInitiation = (SpiPaymentInitialisationResponse)this.createPaymentInitiation(this.spiCmsPisMapper.mapToSpiSinglePayment(payments.get(0)), aspspConsentData).getPayload();
            paymentId = paymentInitiation.getPaymentId();
        } else if (PaymentType.PERIODIC == paymentType) {
            SpiPaymentInitialisationResponse paymentInitiation = (SpiPaymentInitialisationResponse)this.initiatePeriodicPayment(this.spiCmsPisMapper.mapToSpiPeriodicPayment(payments.get(0)), aspspConsentData).getPayload();
            paymentId = paymentInitiation.getPaymentId();
        } else {
            List paymentInitiation = (List)this.createBulkPayments(this.spiCmsPisMapper.mapToSpiBulkPayment(payments), aspspConsentData).getPayload();
            paymentId = ((SpiPaymentInitialisationResponse)paymentInitiation.get(0)).getPaymentId();
        }
        return new SpiResponse((Object)paymentId, aspspConsentData);
    }

    public SpiResponse<Void> performStrongUserAuthorisation(String psuId, SpiScaMethod choosenScaMethod, AspspConsentData aspspConsentData) {
        this.aspspRestTemplate.exchange(this.aspspRemoteUrls.getGenerateTanConfirmation(), HttpMethod.POST, null, Void.class, new Object[]{psuId, choosenScaMethod});
        return new SpiResponse(null, aspspConsentData);
    }

    public SpiResponse<Void> applyStrongUserAuthorisation(SpiScaConfirmation confirmation, AspspConsentData aspspConsentData) {
        this.aspspRestTemplate.exchange(this.aspspRemoteUrls.applyStrongUserAuthorisation(), HttpMethod.PUT, new HttpEntity((Object)confirmation), ResponseEntity.class, new Object[0]);
        return new SpiResponse(null, aspspConsentData);
    }

    @ConstructorProperties(value={"aspspRemoteUrls", "aspspRestTemplate", "keycloakInvokerService", "jsonConverter", "spiPaymentMapper", "spiCmsPisMapper"})
    public PaymentSpiImpl(AspspRemoteUrls aspspRemoteUrls, RestTemplate aspspRestTemplate, KeycloakInvokerService keycloakInvokerService, SpiMockJsonConverter jsonConverter, SpiPaymentMapper spiPaymentMapper, SpiCmsPisMapper spiCmsPisMapper) {
        this.aspspRemoteUrls = aspspRemoteUrls;
        this.aspspRestTemplate = aspspRestTemplate;
        this.keycloakInvokerService = keycloakInvokerService;
        this.jsonConverter = jsonConverter;
        this.spiPaymentMapper = spiPaymentMapper;
        this.spiCmsPisMapper = spiCmsPisMapper;
    }
}

