/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl;

import de.adorsys.aspsp.xs2a.component.JsonConverter;
import de.adorsys.aspsp.xs2a.exception.RestException;
import de.adorsys.aspsp.xs2a.spi.config.rest.AspspRemoteUrls;
import de.adorsys.aspsp.xs2a.spi.impl.service.KeycloakInvokerService;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaMethod;
import de.adorsys.psd2.xs2a.spi.domain.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import de.adorsys.psd2.xs2a.spi.service.PaymentAuthorisationSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class PaymentAuthorisationSpiImpl
implements PaymentAuthorisationSpi {
    private static final String TEST_ASPSP_DATA = "Test aspsp data";
    @Qualifier(value="aspspRestTemplate")
    private final RestTemplate aspspRestTemplate;
    private final AspspRemoteUrls aspspRemoteUrls;
    private final KeycloakInvokerService keycloakInvokerService;
    private final JsonConverter jsonConverter;

    @NotNull
    public SpiResponse<SpiAuthorisationStatus> authorisePsu(@NotNull SpiPsuData psuData, String password, SpiPayment payment, AspspConsentData aspspConsentData) {
        Optional accessToken = this.keycloakInvokerService.obtainAuthorisationData(psuData.getPsuId(), password);
        SpiAuthorisationStatus spiAuthorisationStatus = accessToken.map(t -> SpiAuthorisationStatus.SUCCESS).orElse(SpiAuthorisationStatus.FAILURE);
        byte[] payload = accessToken.flatMap(arg_0 -> ((JsonConverter)this.jsonConverter).toJson(arg_0)).map(String::getBytes).orElse(null);
        return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(payload)).payload((Object)spiAuthorisationStatus).success();
    }

    @NotNull
    public SpiResponse<List<SpiScaMethod>> requestAvailableScaMethods(@NotNull SpiPsuData psuData, SpiPayment payment, AspspConsentData aspspConsentData) {
        try {
            ResponseEntity aspspResponse = this.aspspRestTemplate.exchange(this.aspspRemoteUrls.getScaMethods(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{psuData.getPsuId()});
            List spiScaMethods = Optional.ofNullable(aspspResponse.getBody()).orElseGet(Collections::emptyList);
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).payload((Object)spiScaMethods).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiAuthorizationCodeResult> requestAuthorisationCode(@NotNull SpiPsuData psuData, @NotNull SpiScaMethod scaMethod, @NotNull SpiPayment payment, @NotNull AspspConsentData aspspConsentData) {
        try {
            this.aspspRestTemplate.exchange(this.aspspRemoteUrls.getGenerateTanConfirmation(), HttpMethod.POST, null, Void.class, new Object[]{psuData.getPsuId(), scaMethod});
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @ConstructorProperties(value={"aspspRestTemplate", "aspspRemoteUrls", "keycloakInvokerService", "jsonConverter"})
    public PaymentAuthorisationSpiImpl(RestTemplate aspspRestTemplate, AspspRemoteUrls aspspRemoteUrls, KeycloakInvokerService keycloakInvokerService, JsonConverter jsonConverter) {
        this.aspspRestTemplate = aspspRestTemplate;
        this.aspspRemoteUrls = aspspRemoteUrls;
        this.keycloakInvokerService = keycloakInvokerService;
        this.jsonConverter = jsonConverter;
    }
}

