/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl;

import de.adorsys.aspsp.xs2a.spi.service.AccountSpi;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiBalanceType;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiAmount;
import de.adorsys.psd2.xs2a.spi.domain.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.spi.domain.fund.SpiFundsConfirmationConsent;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.FundsConfirmationSpi;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class FundsConfirmationSpiImpl
implements FundsConfirmationSpi {
    private final AccountSpi accountSpi;

    @NotNull
    public SpiResponse<Boolean> peformFundsSufficientCheck(@NotNull SpiPsuData psuData, SpiFundsConfirmationConsent consent, SpiAccountReference reference, SpiAmount amount, AspspConsentData aspspConsentData) {
        List accounts = (List)this.accountSpi.readAccountDetailsByIban(reference.getIban(), aspspConsentData).getPayload();
        List balances = this.extractAccountBalancesByCurrency(accounts, reference.getCurrency());
        return new SpiResponse((Object)this.isBalancesSufficient(balances, amount), aspspConsentData);
    }

    private boolean isBalancesSufficient(List<SpiAccountBalance> balances, SpiAmount amount) {
        return balances.stream().filter(bal -> SpiBalanceType.INTERIM_AVAILABLE == bal.getSpiBalanceType()).findFirst().map(SpiAccountBalance::getSpiBalanceAmount).map(am -> this.isRequiredAmountEnough(amount, am)).orElse(false);
    }

    private boolean isRequiredAmountEnough(SpiAmount requiredAmount, SpiAmount availableAmount) {
        return availableAmount.getAmount().compareTo(requiredAmount.getAmount()) >= 0 && availableAmount.getCurrency() == requiredAmount.getCurrency();
    }

    private List<SpiAccountBalance> extractAccountBalancesByCurrency(List<SpiAccountDetails> accounts, Currency currency) {
        return accounts.stream().filter(spiAcc -> spiAcc.getCurrency() == currency).findFirst().map(SpiAccountDetails::getBalances).orElseGet(Collections::emptyList);
    }

    @ConstructorProperties(value={"accountSpi"})
    public FundsConfirmationSpiImpl(AccountSpi accountSpi) {
        this.accountSpi = accountSpi;
    }
}

