/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl;

import de.adorsys.aspsp.xs2a.exception.RestException;
import de.adorsys.aspsp.xs2a.spi.component.SpiMockJsonConverter;
import de.adorsys.aspsp.xs2a.spi.config.rest.AspspRemoteUrls;
import de.adorsys.aspsp.xs2a.spi.impl.service.KeycloakInvokerService;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaMethod;
import de.adorsys.psd2.xs2a.spi.domain.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class AisConsentSpiImpl
implements AisConsentSpi {
    private static final Logger log = LoggerFactory.getLogger(AisConsentSpiImpl.class);
    private final AspspRemoteUrls remoteSpiUrls;
    @Qualifier(value="aspspRestTemplate")
    private final RestTemplate aspspRestTemplate;
    private final KeycloakInvokerService keycloakInvokerService;
    private final SpiMockJsonConverter jsonConverter;
    private static final String TEST_ASPSP_DATA = "Test aspsp data";
    private static final String TEST_MESSAGE = "Test message";

    public SpiResponse<SpiResponse.VoidResponse> initiateAisConsent(@NotNull SpiPsuData spiPsuData, SpiAccountConsent accountConsent, AspspConsentData initialAspspConsentData) {
        log.info("AisConsentSpi initiateAisConsent() mock implementation");
        return SpiResponse.builder().aspspConsentData(initialAspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).message(Collections.singletonList(TEST_MESSAGE)).success();
    }

    public SpiResponse<SpiResponse.VoidResponse> revokeAisConsent(@NotNull SpiPsuData spiPsuData, SpiAccountConsent accountConsent, AspspConsentData aspspConsentData) {
        log.info("AisConsentSpi revokeAisConsent() mock implementation");
        return SpiResponse.builder().aspspConsentData(aspspConsentData.respondWith(TEST_ASPSP_DATA.getBytes())).message(Collections.singletonList(TEST_MESSAGE)).success();
    }

    public SpiResponse<SpiAuthorisationStatus> authorisePsu(@NotNull SpiPsuData psuData, String password, SpiAccountConsent accountConsent, AspspConsentData aspspConsentData) {
        Optional accessToken = this.keycloakInvokerService.obtainAuthorisationData(psuData.getPsuId(), password);
        SpiAuthorisationStatus spiAuthorisationStatus = accessToken.map(t -> SpiAuthorisationStatus.SUCCESS).orElse(SpiAuthorisationStatus.FAILURE);
        byte[] payload = accessToken.flatMap(arg_0 -> ((SpiMockJsonConverter)this.jsonConverter).toJson(arg_0)).map(String::getBytes).orElse(null);
        return new SpiResponse((Object)spiAuthorisationStatus, aspspConsentData.respondWith(payload));
    }

    public SpiResponse<List<SpiScaMethod>> requestAvailableScaMethods(@NotNull SpiPsuData psuData, SpiAccountConsent accountConsent, AspspConsentData aspspConsentData) {
        ResponseEntity response = this.aspspRestTemplate.exchange(this.remoteSpiUrls.getScaMethods(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{psuData.getPsuId()});
        List spiScaMethods = Optional.ofNullable(response.getBody()).orElseGet(Collections::emptyList);
        return new SpiResponse((Object)spiScaMethods, aspspConsentData);
    }

    @NotNull
    public SpiResponse<SpiAuthorizationCodeResult> requestAuthorisationCode(@NotNull SpiPsuData psuData, @NotNull SpiScaMethod scaMethod, @NotNull SpiAccountConsent accountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            this.aspspRestTemplate.exchange(this.remoteSpiUrls.getGenerateTanConfirmationForAis(), HttpMethod.POST, null, Void.class, new Object[]{psuData.getPsuId()});
            return SpiResponse.builder().success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @NotNull
    public SpiResponse<SpiResponse.VoidResponse> verifyScaAuthorisation(@NotNull SpiPsuData psuData, @NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiAccountConsent accountConsent, @NotNull AspspConsentData aspspConsentData) {
        try {
            this.aspspRestTemplate.exchange(this.remoteSpiUrls.applyStrongUserAuthorisationForAis(), HttpMethod.PUT, new HttpEntity((Object)spiScaConfirmation), Void.class, new Object[0]);
            return SpiResponse.builder().success();
        }
        catch (RestException e) {
            if (e.getHttpStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
                return SpiResponse.builder().fail(SpiResponseStatus.TECHNICAL_FAILURE);
            }
            return SpiResponse.builder().fail(SpiResponseStatus.LOGICAL_FAILURE);
        }
    }

    @ConstructorProperties(value={"remoteSpiUrls", "aspspRestTemplate", "keycloakInvokerService", "jsonConverter"})
    public AisConsentSpiImpl(AspspRemoteUrls remoteSpiUrls, RestTemplate aspspRestTemplate, KeycloakInvokerService keycloakInvokerService, SpiMockJsonConverter jsonConverter) {
        this.remoteSpiUrls = remoteSpiUrls;
        this.aspspRestTemplate = aspspRestTemplate;
        this.keycloakInvokerService = keycloakInvokerService;
        this.jsonConverter = jsonConverter;
    }
}

