/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.spi.impl;

import de.adorsys.aspsp.xs2a.spi.component.SpiMockJsonConverter;
import de.adorsys.aspsp.xs2a.spi.config.rest.AspspRemoteUrls;
import de.adorsys.aspsp.xs2a.spi.domain.ObjectHolder;
import de.adorsys.aspsp.xs2a.spi.impl.service.KeycloakInvokerService;
import de.adorsys.aspsp.xs2a.spi.service.AccountSpi;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaMethod;
import de.adorsys.psd2.xs2a.spi.domain.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class AccountSpiImpl
implements AccountSpi {
    private final AspspRemoteUrls remoteSpiUrls;
    @Qualifier(value="aspspRestTemplate")
    private final RestTemplate aspspRestTemplate;
    private final KeycloakInvokerService keycloakInvokerService;
    private final SpiMockJsonConverter jsonConverter;

    public SpiResponse<List<SpiAccountDetails>> readAccountDetailsByIban(String iban, AspspConsentData aspspConsentData) {
        List response = Optional.ofNullable(this.aspspRestTemplate.exchange(this.remoteSpiUrls.getAccountDetailsByIban(), HttpMethod.GET, new HttpEntity(null), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{iban}).getBody()).orElseGet(Collections::emptyList);
        return new SpiResponse((Object)response, aspspConsentData);
    }

    public SpiResponse<List<SpiTransaction>> readTransactionsByPeriod(String accountId, LocalDate dateFrom, LocalDate dateTo, AspspConsentData aspspConsentData) {
        Map uriParams = new ObjectHolder().addValue((Object)"account-id", (Object)accountId).getValues();
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.remoteSpiUrls.readTransactionsByPeriod()).queryParam("dateFrom", new Object[]{dateFrom}).queryParam("dateTo", new Object[]{dateTo});
        Optional<Object> response = Optional.ofNullable(this.aspspRestTemplate.exchange(builder.buildAndExpand(uriParams).toUriString(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]).getBody());
        return new SpiResponse((Object)response.orElseGet(ArrayList::new), aspspConsentData);
    }

    public SpiResponse<Optional<SpiTransaction>> readTransactionById(String transactionId, String accountId, AspspConsentData aspspConsentData) {
        Optional<Object> response = Optional.ofNullable(this.aspspRestTemplate.getForObject(this.remoteSpiUrls.readTransactionById(), SpiTransaction.class, new Object[]{transactionId, accountId}));
        return new SpiResponse(response, aspspConsentData);
    }

    public SpiResponse<SpiAccountDetails> readAccountDetails(String accountId, AspspConsentData aspspConsentData) {
        SpiAccountDetails response = (SpiAccountDetails)this.aspspRestTemplate.getForObject(this.remoteSpiUrls.getAccountDetailsById(), SpiAccountDetails.class, new Object[]{accountId});
        return new SpiResponse((Object)response, aspspConsentData);
    }

    public SpiResponse<List<SpiAccountDetails>> readAccountsByPsuId(String psuId, AspspConsentData aspspConsentData) {
        List response = Optional.ofNullable(this.aspspRestTemplate.exchange(this.remoteSpiUrls.getAccountDetailsByPsuId(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{psuId}).getBody()).orElseGet(Collections::emptyList);
        return new SpiResponse((Object)response, aspspConsentData);
    }

    public SpiResponse<List<SpiAccountDetails>> readAccountDetailsByIbans(Collection<String> ibans, AspspConsentData aspspConsentData) {
        ArrayList accountDetails = new ArrayList();
        for (String iban : ibans) {
            List det = (List)this.readAccountDetailsByIban(iban, aspspConsentData).getPayload();
            if (CollectionUtils.isEmpty((Collection)det)) {
                return new SpiResponse(Collections.emptyList(), aspspConsentData);
            }
            accountDetails.addAll(det);
        }
        return new SpiResponse(accountDetails, aspspConsentData);
    }

    public SpiResponse<List<String>> readPsuAllowedPaymentProductList(SpiAccountReference reference, AspspConsentData aspspConsentData) {
        List response = Optional.ofNullable(this.aspspRestTemplate.exchange(this.remoteSpiUrls.getAllowedPaymentProducts(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{reference.getIban()}).getBody()).orElseGet(Collections::emptyList);
        return new SpiResponse((Object)response, aspspConsentData);
    }

    public SpiResponse<List<SpiScaMethod>> readAvailableScaMethods(String psuId, String password, AspspConsentData aspspConsentData) {
        ResponseEntity response = this.aspspRestTemplate.exchange(this.remoteSpiUrls.getScaMethods(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{psuId});
        List spiScaMethods = Optional.ofNullable(response.getBody()).orElseGet(Collections::emptyList);
        return new SpiResponse((Object)spiScaMethods, aspspConsentData);
    }

    public SpiResponse<SpiAuthorisationStatus> authorisePsu(String psuId, String password, AspspConsentData aspspConsentData) {
        Optional accessToken = this.keycloakInvokerService.obtainAuthorisationData(psuId, password);
        SpiAuthorisationStatus spiAuthorisationStatus = accessToken.map(t -> SpiAuthorisationStatus.SUCCESS).orElse(SpiAuthorisationStatus.FAILURE);
        byte[] payload = accessToken.flatMap(arg_0 -> ((SpiMockJsonConverter)this.jsonConverter).toJson(arg_0)).map(String::getBytes).orElse(null);
        return new SpiResponse((Object)spiAuthorisationStatus, aspspConsentData.respondWith(payload));
    }

    public void performStrongUserAuthorisation(String psuId, AspspConsentData aspspConsentData) {
        this.aspspRestTemplate.exchange(this.remoteSpiUrls.getGenerateTanConfirmationForAis(), HttpMethod.POST, null, Void.class, new Object[]{psuId});
    }

    public void applyStrongUserAuthorisation(SpiAccountConfirmation confirmation, AspspConsentData aspspConsentData) {
        this.aspspRestTemplate.exchange(this.remoteSpiUrls.applyStrongUserAuthorisationForAis(), HttpMethod.PUT, new HttpEntity((Object)confirmation), ResponseEntity.class, new Object[0]);
    }

    @ConstructorProperties(value={"remoteSpiUrls", "aspspRestTemplate", "keycloakInvokerService", "jsonConverter"})
    public AccountSpiImpl(AspspRemoteUrls remoteSpiUrls, RestTemplate aspspRestTemplate, KeycloakInvokerService keycloakInvokerService, SpiMockJsonConverter jsonConverter) {
        this.remoteSpiUrls = remoteSpiUrls;
        this.aspspRestTemplate = aspspRestTemplate;
        this.keycloakInvokerService = keycloakInvokerService;
        this.jsonConverter = jsonConverter;
    }
}

