/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web;

import de.adorsys.aspsp.xs2a.consent.api.CmsConsentStatus;
import de.adorsys.aspsp.xs2a.consent.api.PisConsentStatusResponse;
import de.adorsys.aspsp.xs2a.consent.api.pis.authorisation.CreatePisConsentAuthorisationResponse;
import de.adorsys.aspsp.xs2a.consent.api.pis.authorisation.GetPisConsentAuthorisationResponse;
import de.adorsys.aspsp.xs2a.consent.api.pis.authorisation.UpdatePisConsentPsuDataRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.authorisation.UpdatePisConsentPsuDataResponse;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.CreatePisConsentResponse;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentResponse;
import de.adorsys.aspsp.xs2a.service.PisConsentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/pis/consent"})
@Api(value="api/v1/pis/consent", tags={"PIS, Consents"}, description="Provides access to consent management system for PIS")
public class PisConsentController {
    private final PisConsentService pisConsentService;

    @PostMapping(path={"/"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CreatePisConsentResponse.class), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<CreatePisConsentResponse> createPaymentConsent(@RequestBody PisConsentRequest request) {
        return this.pisConsentService.createPaymentConsent(request).map(c -> new ResponseEntity(c, HttpStatus.CREATED)).orElseGet(() -> new ResponseEntity(HttpStatus.BAD_REQUEST));
    }

    @GetMapping(path={"/{consent-id}/status"})
    @ApiOperation(value="")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=PisConsentStatusResponse.class), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<PisConsentStatusResponse> getConsentStatusById(@ApiParam(name="consent-id", value="The payment consent identification assigned to the created payment consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId) {
        return this.pisConsentService.getConsentStatusById(consentId).map(status -> new ResponseEntity((Object)new PisConsentStatusResponse(status), HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.BAD_REQUEST));
    }

    @GetMapping(path={"/{consent-id}"})
    @ApiOperation(value="")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=PisConsentResponse.class), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<PisConsentResponse> getConsentById(@ApiParam(name="consent-id", value="The payment consent identification assigned to the created payment consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId) {
        return this.pisConsentService.getConsentById(consentId).map(pc -> new ResponseEntity(pc, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.BAD_REQUEST));
    }

    @PutMapping(path={"/{consent-id}/status/{status}"})
    @ApiOperation(value="")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<Void> updateConsentStatus(@ApiParam(name="consent-id", value="The payment consent identification assigned to the created payment consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @ApiParam(value="The following code values are permitted 'received', 'valid', 'rejected', 'expired', 'revoked by psu', 'terminated by tpp'. These values might be extended by ASPSP by more values.", allowableValues="RECEIVED,  REJECTED, VALID, REVOKED_BY_PSU,  EXPIRED,  TERMINATED_BY_TPP") @PathVariable(value="status") String status) {
        return this.pisConsentService.updateConsentStatusById(consentId, CmsConsentStatus.valueOf((String)status)).map(updated -> new ResponseEntity(HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.BAD_REQUEST));
    }

    @PostMapping(path={"/{payment-id}/authorizations"})
    @ApiOperation(value="Create consent authorization for given consent id.")
    @ApiResponses(value={@ApiResponse(code=201, message="Created"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<CreatePisConsentAuthorisationResponse> createConsentAuthorization(@ApiParam(name="payment-id", value="The consent identification assigned to the created consent authorization.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="payment-id") String paymentId) {
        return this.pisConsentService.createAuthorization(paymentId).map(authorization -> new ResponseEntity(authorization, HttpStatus.CREATED)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @PutMapping(path={"/authorizations/{authorization-id}"})
    @ApiOperation(value="Update pis consent authorization.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<UpdatePisConsentPsuDataResponse> updateConsentAuthorization(@ApiParam(name="authorization-id", value="The consent authorization identification assigned to the created authorization.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="authorization-id") String authorizationId, @RequestBody UpdatePisConsentPsuDataRequest request) {
        return this.pisConsentService.updateConsentAuthorization(authorizationId, request).map(updated -> new ResponseEntity(updated, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @GetMapping(path={"/authorizations/{authorization-id}"})
    @ApiOperation(value="Getting pis consent authorization.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<GetPisConsentAuthorisationResponse> getConsentAuthorization(@ApiParam(name="authorization-id", value="The consent authorization identification assigned to the created authorization.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="authorization-id") String authorizationId) {
        return this.pisConsentService.getPisConsentAuthorizationById(authorizationId).map(resp -> new ResponseEntity(resp, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @ConstructorProperties(value={"pisConsentService"})
    public PisConsentController(PisConsentService pisConsentService) {
        this.pisConsentService = pisConsentService;
    }
}

