/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web;

import de.adorsys.aspsp.xs2a.consent.api.UpdateConsentAspspDataRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisConsentAspspDataResponse;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.CreatePisConsentResponse;
import de.adorsys.aspsp.xs2a.service.PisConsentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/pis"})
@Api(value="api/v1/pis", tags={"PIS, Aspsp Consent Data"}, description="Provides access to consent management system for AspspDataConsent")
public class AspspConsentDataController {
    private final PisConsentService pisConsentService;

    @GetMapping(path={"/consent/{consent-id}/aspsp-consent-data"})
    @ApiOperation(value="Get aspsp consent data identified by given consent id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<PisConsentAspspDataResponse> getAspspConsentData(@ApiParam(name="consent-id", value="The payment consent identification assigned to the created payment consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId) {
        return this.pisConsentService.getAspspConsentDataByConsentId(consentId).map(response -> new ResponseEntity(response, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @PutMapping(path={"/consent/{consent-id}/aspsp-consent-data"})
    @ApiOperation(value="Update aspsp consent data identified by given consent id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<CreatePisConsentResponse> updateAspspConsentData(@ApiParam(name="consent-id", value="The payment consent identification assigned to the created payment consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @RequestBody UpdateConsentAspspDataRequest request) {
        return this.pisConsentService.updateAspspConsentData(consentId, request).map(consId -> new ResponseEntity((Object)new CreatePisConsentResponse(consId), HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @GetMapping(path={"/payment/{payment-id}/aspsp-consent-data"})
    @ApiOperation(value="Get aspsp consent data identified by given payment id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<PisConsentAspspDataResponse> getAspspConsentDataByPaymentId(@ApiParam(name="payment-id", value="The payment identification.", example="32454656712432") @PathVariable(value="payment-id") String paymentId) {
        return this.pisConsentService.getAspspConsentDataByPaymentId(paymentId).map(response -> new ResponseEntity(response, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @ConstructorProperties(value={"pisConsentService"})
    public AspspConsentDataController(PisConsentService pisConsentService) {
        this.pisConsentService = pisConsentService;
    }
}

