/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web;

import de.adorsys.aspsp.xs2a.consent.api.AisConsentStatusResponse;
import de.adorsys.aspsp.xs2a.consent.api.CmsConsentStatus;
import de.adorsys.aspsp.xs2a.consent.api.ConsentActionRequest;
import de.adorsys.aspsp.xs2a.consent.api.UpdateConsentAspspDataRequest;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisAccountConsent;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisConsentAspspDataResponse;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisConsentAuthorizationRequest;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisConsentAuthorizationResponse;
import de.adorsys.aspsp.xs2a.consent.api.ais.CreateAisConsentAuthorizationResponse;
import de.adorsys.aspsp.xs2a.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.aspsp.xs2a.consent.api.ais.CreateAisConsentResponse;
import de.adorsys.aspsp.xs2a.service.AisConsentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/ais/consent"})
@Api(value="api/v1/ais/consent", tags={"AIS, Consents"}, description="Provides access to consent management system for AIS")
public class AisConsentController {
    private final AisConsentService aisConsentService;

    @PostMapping(path={"/"})
    @ApiOperation(value="Create consent for given psu id and accesses.")
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=String.class), @ApiResponse(code=204, message="No Content")})
    public ResponseEntity<CreateAisConsentResponse> createConsent(@RequestBody CreateAisConsentRequest request) {
        return this.aisConsentService.createConsent(request).map(consentId -> new ResponseEntity((Object)new CreateAisConsentResponse(consentId), HttpStatus.CREATED)).orElseGet(() -> new ResponseEntity(HttpStatus.NO_CONTENT));
    }

    @PostMapping(path={"/action"})
    @ApiOperation(value="Save information about uses of consent")
    public ResponseEntity<Void> saveConsentActionLog(@RequestBody ConsentActionRequest request) {
        this.aisConsentService.checkConsentAndSaveActionLog(request);
        return ResponseEntity.ok().build();
    }

    @GetMapping(path={"/{consent-id}"})
    @ApiOperation(value="Read account consent by given consent id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=AisAccountConsent.class), @ApiResponse(code=204, message="No Content")})
    public ResponseEntity<AisAccountConsent> getConsentById(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId) {
        return this.aisConsentService.getAisAccountConsentById(consentId).map(consent -> new ResponseEntity(consent, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NO_CONTENT));
    }

    @PutMapping(path={"/{consent-id}/access"})
    @ApiOperation(value="Update AccountAccess in the consent identified by given consent id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<CreateAisConsentResponse> updateAccountAccess(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @RequestBody AisAccountAccessInfo request) {
        return this.aisConsentService.updateAccountAccess(consentId, request).map(consentIdUpdated -> new ResponseEntity((Object)new CreateAisConsentResponse(consentIdUpdated), HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @GetMapping(path={"/{consent-id}/aspsp-consent-data"})
    @ApiOperation(value="Get aspsp consent data identified by given consent id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<AisConsentAspspDataResponse> getAspspConsentData(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId) {
        return this.aisConsentService.getAspspConsentData(consentId).map(response -> new ResponseEntity(response, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @PutMapping(path={"/{consent-id}/aspsp-consent-data"})
    @ApiOperation(value="Update aspsp consent data identified by given consent id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<CreateAisConsentResponse> updateAspspConsentData(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @RequestBody UpdateConsentAspspDataRequest request) {
        return this.aisConsentService.updateAspspConsentData(consentId, request).map(consId -> new ResponseEntity((Object)new CreateAisConsentResponse(consId), HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @GetMapping(path={"/{consent-id}/status"})
    @ApiOperation(value="Can check the status of an account information consent resource.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CmsConsentStatus.class), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<AisConsentStatusResponse> getConsentStatusById(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId) {
        return this.aisConsentService.getConsentStatusById(consentId).map(status -> new ResponseEntity((Object)new AisConsentStatusResponse(status), HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @PutMapping(path={"/{consent-id}/status/{status}"})
    @ApiOperation(value="Update consent status in the consent identified by given consent id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Void> updateConsentStatus(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @ApiParam(value="The following code values are permitted 'VALID', 'REJECTED', 'REVOKED_BY_PSU', 'TERMINATED_BY_TPP'. These values might be extended by ASPSP by more values.", example="VALID") @PathVariable(value="status") String status) {
        return this.aisConsentService.updateConsentStatusById(consentId, CmsConsentStatus.valueOf((String)status)).map(updated -> new ResponseEntity(HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @PostMapping(path={"/{consent-id}/authorizations"})
    @ApiOperation(value="Create consent authorization for given consent id.")
    @ApiResponses(value={@ApiResponse(code=201, message="Created"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<CreateAisConsentAuthorizationResponse> createConsentAuthorization(@ApiParam(name="consent-id", value="The consent identification assigned to the created consent authorization.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @RequestBody AisConsentAuthorizationRequest consentAuthorization) {
        return this.aisConsentService.createAuthorization(consentId, consentAuthorization).map(authorizationId -> new ResponseEntity((Object)new CreateAisConsentAuthorizationResponse(authorizationId), HttpStatus.CREATED)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @PutMapping(path={"/{consent-id}/authorizations/{authorization-id}"})
    @ApiOperation(value="Update consent authorization.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Void> updateConsentAuthorization(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @ApiParam(name="authorization-id", value="The consent authorization identification assigned to the created authorization.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="authorization-id") String authorizationId, @ApiParam(value="The following code values are permitted 'VALID', 'REJECTED', 'REVOKED_BY_PSU', 'TERMINATED_BY_TPP'. These values might be extended by ASPSP by more values.", example="VALID") @RequestBody AisConsentAuthorizationRequest consentAuthorization) {
        return this.aisConsentService.updateConsentAuthorization(authorizationId, consentId, consentAuthorization).map(updated -> new ResponseEntity(HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @GetMapping(path={"/{consent-id}/authorizations/{authorization-id}"})
    @ApiOperation(value="Getting consent authorization.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<AisConsentAuthorizationResponse> getConsentAuthorization(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @ApiParam(name="authorization-id", value="The consent authorization identification assigned to the created authorization.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="authorization-id") String authorizationId) {
        return this.aisConsentService.getAccountConsentAuthorizationById(authorizationId, consentId).map(resp -> new ResponseEntity(resp, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @ConstructorProperties(value={"aisConsentService"})
    public AisConsentController(AisConsentService aisConsentService) {
        this.aisConsentService = aisConsentService;
    }
}

