/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.mapper;

import de.adorsys.aspsp.xs2a.consent.api.CmsAccountReference;
import de.adorsys.aspsp.xs2a.consent.api.TypeAccess;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisAccountAccess;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisAccountConsent;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisConsentAuthorizationResponse;
import de.adorsys.aspsp.xs2a.domain.AccountAccess;
import de.adorsys.aspsp.xs2a.domain.AisConsent;
import de.adorsys.aspsp.xs2a.domain.AisConsentAuthorization;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class AisConsentMapper {
    public AisAccountConsent mapToAisAccountConsent(AisConsent consent) {
        return new AisAccountConsent(consent.getId().toString(), this.mapToAisAccountAccess(consent.getAccesses()), consent.isRecurringIndicator(), consent.getExpireDate(), consent.getUsageCounter(), consent.getLastActionDate(), consent.getConsentStatus(), false, consent.isTppRedirectPreferred(), consent.getAspspConsentData(), consent.getAisConsentRequestType(), consent.getPsuId(), consent.getTppId());
    }

    public AisConsentAuthorizationResponse mapToAisConsentAuthorizationResponse(AisConsentAuthorization aisConsentAuthorization) {
        return Optional.ofNullable(aisConsentAuthorization).map(conAuth -> {
            AisConsentAuthorizationResponse resp = new AisConsentAuthorizationResponse();
            resp.setAuthorizationId(conAuth.getExternalId());
            resp.setPsuId(conAuth.getPsuId());
            resp.setConsentId(conAuth.getConsent().getExternalId());
            resp.setScaStatus(conAuth.getScaStatus());
            resp.setAuthenticationMethodId(conAuth.getAuthenticationMethodId());
            resp.setPassword(conAuth.getPassword());
            resp.setScaAuthenticationData(conAuth.getScaAuthenticationData());
            return resp;
        }).orElse(null);
    }

    private AisAccountAccess mapToAisAccountAccess(List<AccountAccess> accountAccesses) {
        return new AisAccountAccess(this.mapToCmsAccountReference(accountAccesses, TypeAccess.ACCOUNT), this.mapToCmsAccountReference(accountAccesses, TypeAccess.BALANCE), this.mapToCmsAccountReference(accountAccesses, TypeAccess.TRANSACTION));
    }

    private List<CmsAccountReference> mapToCmsAccountReference(List<AccountAccess> aisAccounts, TypeAccess typeAccess) {
        return aisAccounts.stream().filter(ass -> ass.getTypeAccess() == typeAccess).map(access -> new CmsAccountReference(access.getIban(), access.getCurrency())).collect(Collectors.toList());
    }
}

