/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.consent.api.CmsAspspConsentData;
import de.adorsys.aspsp.xs2a.consent.api.CmsConsentStatus;
import de.adorsys.aspsp.xs2a.consent.api.CmsScaMethod;
import de.adorsys.aspsp.xs2a.consent.api.CmsScaStatus;
import de.adorsys.aspsp.xs2a.consent.api.UpdateConsentAspspDataRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisConsentAspspDataResponse;
import de.adorsys.aspsp.xs2a.consent.api.pis.authorisation.CreatePisConsentAuthorisationResponse;
import de.adorsys.aspsp.xs2a.consent.api.pis.authorisation.GetPisConsentAuthorisationResponse;
import de.adorsys.aspsp.xs2a.consent.api.pis.authorisation.UpdatePisConsentPsuDataRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.authorisation.UpdatePisConsentPsuDataResponse;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.CreatePisConsentResponse;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentResponse;
import de.adorsys.aspsp.xs2a.domain.pis.PisConsent;
import de.adorsys.aspsp.xs2a.domain.pis.PisConsentAuthorization;
import de.adorsys.aspsp.xs2a.domain.pis.PisPaymentData;
import de.adorsys.aspsp.xs2a.repository.PisConsentAuthorizationRepository;
import de.adorsys.aspsp.xs2a.repository.PisConsentRepository;
import de.adorsys.aspsp.xs2a.repository.PisPaymentDataRepository;
import de.adorsys.aspsp.xs2a.service.mapper.PisConsentMapper;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PisConsentService {
    private final PisConsentRepository pisConsentRepository;
    private final PisConsentMapper pisConsentMapper;
    private final PisConsentAuthorizationRepository pisConsentAuthorizationRepository;
    private final PisPaymentDataRepository pisPaymentDataRepository;

    public Optional<CreatePisConsentResponse> createPaymentConsent(PisConsentRequest request) {
        return this.pisConsentMapper.mapToPisConsent(request).map(arg_0 -> ((PisConsentRepository)this.pisConsentRepository).save(arg_0)).map(r -> new CreatePisConsentResponse(r.getExternalId()));
    }

    public Optional<CmsConsentStatus> getConsentStatusById(String consentId) {
        return this.getPisConsentById(consentId).map(PisConsent::getConsentStatus);
    }

    public Optional<PisConsentResponse> getConsentById(String consentId) {
        return this.getPisConsentById(consentId).flatMap(arg_0 -> ((PisConsentMapper)this.pisConsentMapper).mapToPisConsentResponse(arg_0));
    }

    public Optional<Boolean> updateConsentStatusById(String consentId, CmsConsentStatus status) {
        return this.getActualPisConsent(consentId).map(con -> this.setStatusAndSaveConsent(con, status)).map(con -> con.getConsentStatus() == status);
    }

    public Optional<PisConsentAspspDataResponse> getAspspConsentDataByConsentId(String consentId) {
        return this.getPisConsentById(consentId).map(arg_0 -> this.prepareAspspConsentData(arg_0));
    }

    public Optional<PisConsentAspspDataResponse> getAspspConsentDataByPaymentId(String paymentId) {
        return this.pisPaymentDataRepository.findByPaymentId(paymentId).map(PisPaymentData::getConsent).map(arg_0 -> this.prepareAspspConsentData(arg_0));
    }

    private PisConsentAspspDataResponse prepareAspspConsentData(PisConsent consent) {
        PisConsentAspspDataResponse response = new PisConsentAspspDataResponse();
        response.setAspspConsentData(consent.getAspspConsentData());
        response.setConsentId(consent.getExternalId());
        return response;
    }

    @Transactional
    public Optional<String> updateAspspConsentData(String consentId, UpdateConsentAspspDataRequest request) {
        return this.getActualPisConsent(consentId).map(cons -> this.updateAspspConsentData(request, cons));
    }

    @Transactional
    public Optional<CreatePisConsentAuthorisationResponse> createAuthorization(String paymentId) {
        return this.pisPaymentDataRepository.findByPaymentIdAndConsent_ConsentStatus(paymentId, CmsConsentStatus.RECEIVED).map(pisConsent -> this.saveNewAuthorization(pisConsent.getConsent())).map(c -> new CreatePisConsentAuthorisationResponse(c.getExternalId()));
    }

    public Optional<UpdatePisConsentPsuDataResponse> updateConsentAuthorization(String authorizationId, UpdatePisConsentPsuDataRequest request) {
        Optional pisConsentAuthorisationOptional = this.pisConsentAuthorizationRepository.findByExternalId(authorizationId);
        if (pisConsentAuthorisationOptional.isPresent()) {
            String chosenMethod;
            PisConsentAuthorization consentAuthorization = (PisConsentAuthorization)pisConsentAuthorisationOptional.get();
            byte[] bytes = Optional.ofNullable(request.getCmsAspspConsentData()).map(CmsAspspConsentData::getBody).orElse(null);
            consentAuthorization.getConsent().setAspspConsentData(bytes);
            if (CmsScaStatus.SCAMETHODSELECTED == request.getScaStatus() && StringUtils.isNotBlank((CharSequence)(chosenMethod = request.getAuthenticationMethodId()))) {
                consentAuthorization.setChosenScaMethod(CmsScaMethod.valueOf((String)chosenMethod));
            }
            consentAuthorization.setScaStatus(request.getScaStatus());
            this.pisConsentAuthorizationRepository.save((Object)consentAuthorization);
        }
        return pisConsentAuthorisationOptional.map(arg_0 -> ((PisConsentMapper)this.pisConsentMapper).mapToUpdatePisConsentPsuDataResponse(arg_0));
    }

    public Optional<GetPisConsentAuthorisationResponse> getPisConsentAuthorizationById(String authorizationId) {
        return this.pisConsentAuthorizationRepository.findByExternalId(authorizationId).map(arg_0 -> ((PisConsentMapper)this.pisConsentMapper).mapToGetPisConsentAuthorizationResponse(arg_0));
    }

    private Optional<PisConsent> getPisConsentById(String consentId) {
        return Optional.ofNullable(consentId).flatMap(arg_0 -> ((PisConsentRepository)this.pisConsentRepository).findByExternalId(arg_0));
    }

    private PisConsent setStatusAndSaveConsent(PisConsent consent, CmsConsentStatus status) {
        consent.setConsentStatus(status);
        return (PisConsent)this.pisConsentRepository.save((Object)consent);
    }

    private Optional<PisConsent> getActualPisConsent(String consentId) {
        return Optional.ofNullable(consentId).flatMap(c -> this.pisConsentRepository.findByExternalIdAndConsentStatusIn(consentId, EnumSet.of(CmsConsentStatus.RECEIVED, CmsConsentStatus.VALID)));
    }

    private PisConsentAuthorization saveNewAuthorization(PisConsent pisConsent) {
        PisConsentAuthorization consentAuthorization = new PisConsentAuthorization();
        consentAuthorization.setExternalId(UUID.randomUUID().toString());
        consentAuthorization.setConsent(pisConsent);
        consentAuthorization.setScaStatus(CmsScaStatus.STARTED);
        return (PisConsentAuthorization)this.pisConsentAuthorizationRepository.save((Object)consentAuthorization);
    }

    private String updateAspspConsentData(UpdateConsentAspspDataRequest request, PisConsent consent) {
        consent.setAspspConsentData(request.getAspspConsentData());
        PisConsent savedConsent = (PisConsent)this.pisConsentRepository.save((Object)consent);
        return savedConsent.getExternalId();
    }

    @ConstructorProperties(value={"pisConsentRepository", "pisConsentMapper", "pisConsentAuthorizationRepository", "pisPaymentDataRepository"})
    public PisConsentService(PisConsentRepository pisConsentRepository, PisConsentMapper pisConsentMapper, PisConsentAuthorizationRepository pisConsentAuthorizationRepository, PisPaymentDataRepository pisPaymentDataRepository) {
        this.pisConsentRepository = pisConsentRepository;
        this.pisConsentMapper = pisConsentMapper;
        this.pisConsentAuthorizationRepository = pisConsentAuthorizationRepository;
        this.pisPaymentDataRepository = pisPaymentDataRepository;
    }
}

