/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.account.AccountAccessHolder;
import de.adorsys.aspsp.xs2a.consent.api.ActionStatus;
import de.adorsys.aspsp.xs2a.consent.api.AisConsentRequestType;
import de.adorsys.aspsp.xs2a.consent.api.CmsConsentStatus;
import de.adorsys.aspsp.xs2a.consent.api.CmsScaStatus;
import de.adorsys.aspsp.xs2a.consent.api.ConsentActionRequest;
import de.adorsys.aspsp.xs2a.consent.api.TypeAccess;
import de.adorsys.aspsp.xs2a.consent.api.UpdateConsentAspspDataRequest;
import de.adorsys.aspsp.xs2a.consent.api.ais.AccountAccessType;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisAccountConsent;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisConsentAspspDataResponse;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisConsentAuthorizationRequest;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisConsentAuthorizationResponse;
import de.adorsys.aspsp.xs2a.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.aspsp.xs2a.domain.AccountAccess;
import de.adorsys.aspsp.xs2a.domain.AisConsent;
import de.adorsys.aspsp.xs2a.domain.AisConsentAction;
import de.adorsys.aspsp.xs2a.domain.AisConsentAuthorization;
import de.adorsys.aspsp.xs2a.repository.AisConsentActionRepository;
import de.adorsys.aspsp.xs2a.repository.AisConsentAuthorizationRepository;
import de.adorsys.aspsp.xs2a.repository.AisConsentRepository;
import de.adorsys.aspsp.xs2a.service.FrequencyPerDateCalculationService;
import de.adorsys.aspsp.xs2a.service.mapper.AisConsentMapper;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AisConsentService {
    private final AisConsentRepository aisConsentRepository;
    private final AisConsentActionRepository aisConsentActionRepository;
    private final AisConsentAuthorizationRepository aisConsentAuthorizationRepository;
    private final AisConsentMapper consentMapper;
    private final FrequencyPerDateCalculationService frequencyPerDateCalculationService;

    @Transactional
    public Optional<String> createConsent(CreateAisConsentRequest request) {
        AisConsent consent = this.createConsentFromRequest(request);
        consent.setExternalId(UUID.randomUUID().toString());
        AisConsent saved = (AisConsent)this.aisConsentRepository.save((Object)consent);
        return saved.getId() != null ? Optional.ofNullable(saved.getExternalId()) : Optional.empty();
    }

    public Optional<CmsConsentStatus> getConsentStatusById(String consentId) {
        return this.getAisConsentById(consentId).map(arg_0 -> this.checkAndUpdateOnExpiration(arg_0)).map(AisConsent::getConsentStatus);
    }

    public Optional<Boolean> updateConsentStatusById(String consentId, CmsConsentStatus status) {
        return this.getActualAisConsent(consentId).map(con -> this.setStatusAndSaveConsent(con, status)).map(con -> con.getConsentStatus() == status);
    }

    public Optional<AisAccountConsent> getAisAccountConsentById(String consentId) {
        return this.getAisConsentById(consentId).map(arg_0 -> this.checkAndUpdateOnExpiration(arg_0)).map(arg_0 -> ((AisConsentMapper)this.consentMapper).mapToAisAccountConsent(arg_0));
    }

    @Transactional
    public void checkConsentAndSaveActionLog(ConsentActionRequest request) {
        AisConsent consent = this.getAisConsentById(request.getConsentId()).orElse(null);
        this.checkAndUpdateOnExpiration(consent);
        this.updateAisConsentCounter(consent);
        this.logConsentAction(request.getConsentId(), this.resolveConsentActionStatus(request, consent), request.getTppId());
    }

    @Transactional
    public Optional<String> updateAccountAccess(String consentId, AisAccountAccessInfo request) {
        return this.getActualAisConsent(consentId).map(consent -> {
            consent.addAccountAccess(this.readAccountAccess(request));
            return ((AisConsent)this.aisConsentRepository.save(consent)).getExternalId();
        });
    }

    public Optional<AisConsentAspspDataResponse> getAspspConsentData(String consentId) {
        return this.getActualAisConsent(consentId).map(arg_0 -> this.getConsentAspspData(arg_0));
    }

    @Transactional
    public Optional<String> updateAspspConsentData(String consentId, UpdateConsentAspspDataRequest request) {
        return this.getActualAisConsent(consentId).map(cons -> this.updateAspspConsentData(request, cons));
    }

    @Transactional
    public Optional<String> createAuthorization(String consentId, AisConsentAuthorizationRequest request) {
        return this.aisConsentRepository.findByExternalIdAndConsentStatusIn(consentId, EnumSet.of(CmsConsentStatus.RECEIVED, CmsConsentStatus.VALID)).map(aisConsent -> this.saveNewAuthorization(aisConsent, request));
    }

    public Optional<AisConsentAuthorizationResponse> getAccountConsentAuthorizationById(String authorizationId, String consentId) {
        return this.aisConsentRepository.findByExternalIdAndConsentStatusIn(consentId, EnumSet.of(CmsConsentStatus.RECEIVED, CmsConsentStatus.VALID)).isPresent() ? this.aisConsentAuthorizationRepository.findByExternalId(authorizationId).map(arg_0 -> ((AisConsentMapper)this.consentMapper).mapToAisConsentAuthorizationResponse(arg_0)) : Optional.empty();
    }

    @Transactional
    public Optional<Boolean> updateConsentAuthorization(String authorizationId, String consentId, AisConsentAuthorizationRequest request) {
        return this.aisConsentRepository.findByExternalIdAndConsentStatusIn(consentId, EnumSet.of(CmsConsentStatus.RECEIVED, CmsConsentStatus.VALID)).isPresent() ? this.updateConsentAuthorization(authorizationId, request) : Optional.of(false);
    }

    private Set<AccountAccess> readAccountAccess(AisAccountAccessInfo access) {
        AccountAccessHolder holder = new AccountAccessHolder();
        holder.fillAccess(access.getAccounts(), TypeAccess.ACCOUNT);
        holder.fillAccess(access.getBalances(), TypeAccess.BALANCE);
        holder.fillAccess(access.getTransactions(), TypeAccess.TRANSACTION);
        return holder.getAccountAccesses();
    }

    private AisConsentAspspDataResponse getConsentAspspData(AisConsent consent) {
        AisConsentAspspDataResponse response = new AisConsentAspspDataResponse();
        response.setAspspConsentData(consent.getAspspConsentData());
        return response;
    }

    private String updateAspspConsentData(UpdateConsentAspspDataRequest request, AisConsent consent) {
        consent.setAspspConsentData(request.getAspspConsentData());
        AisConsent savedConsent = (AisConsent)this.aisConsentRepository.save((Object)consent);
        return savedConsent.getExternalId();
    }

    private AisConsent createConsentFromRequest(CreateAisConsentRequest request) {
        int minFrequencyPerDay = this.frequencyPerDateCalculationService.getMinFrequencyPerDay(request.getFrequencyPerDay());
        AisConsent consent = new AisConsent();
        consent.setConsentStatus(CmsConsentStatus.RECEIVED);
        consent.setExpectedFrequencyPerDay(minFrequencyPerDay);
        consent.setTppFrequencyPerDay(request.getFrequencyPerDay());
        consent.setUsageCounter(minFrequencyPerDay);
        consent.setRequestDateTime(LocalDateTime.now());
        consent.setExpireDate(request.getValidUntil());
        consent.setPsuId(request.getPsuId());
        consent.setTppId(request.getTppId());
        consent.addAccountAccess(this.readAccountAccess(request.getAccess()));
        consent.setRecurringIndicator(request.isRecurringIndicator());
        consent.setTppRedirectPreferred(request.isTppRedirectPreferred());
        consent.setCombinedServiceIndicator(request.isCombinedServiceIndicator());
        consent.setAspspConsentData(request.getAspspConsentData());
        consent.setAisConsentRequestType(this.getRequestTypeFromAccess(request.getAccess()));
        return consent;
    }

    private AisConsentRequestType getRequestTypeFromAccess(AisAccountAccessInfo accessInfo) {
        if (accessInfo.getAllPsd2() == AccountAccessType.ALL_ACCOUNTS) {
            return AisConsentRequestType.GLOBAL;
        }
        if (EnumSet.of(AccountAccessType.ALL_ACCOUNTS, AccountAccessType.ALL_ACCOUNTS_WITH_BALANCES).contains(accessInfo.getAvailableAccounts())) {
            return AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS;
        }
        if (this.isEmptyAccess(accessInfo)) {
            return AisConsentRequestType.BANK_OFFERED;
        }
        return AisConsentRequestType.DEDICATED_ACCOUNTS;
    }

    private boolean isEmptyAccess(AisAccountAccessInfo accessInfo) {
        return CollectionUtils.isEmpty((Collection)accessInfo.getAccounts()) && CollectionUtils.isEmpty((Collection)accessInfo.getBalances()) && CollectionUtils.isEmpty((Collection)accessInfo.getTransactions());
    }

    private ActionStatus resolveConsentActionStatus(ConsentActionRequest request, AisConsent consent) {
        return consent == null ? ActionStatus.BAD_PAYLOAD : request.getActionStatus();
    }

    private void updateAisConsentCounter(AisConsent consent) {
        if (consent != null && consent.hasUsagesAvailable()) {
            int usageCounter = consent.getUsageCounter();
            int newUsageCounter = --usageCounter;
            consent.setUsageCounter(newUsageCounter);
            consent.setLastActionDate(LocalDate.now());
            this.aisConsentRepository.save((Object)consent);
        }
    }

    private void logConsentAction(String requestedConsentId, ActionStatus actionStatus, String tppId) {
        AisConsentAction action = new AisConsentAction();
        action.setActionStatus(actionStatus);
        action.setRequestedConsentId(requestedConsentId);
        action.setTppId(tppId);
        action.setRequestDate(LocalDate.now());
        this.aisConsentActionRepository.save((Object)action);
    }

    private Optional<AisConsent> getActualAisConsent(String consentId) {
        return Optional.ofNullable(consentId).flatMap(c -> this.aisConsentRepository.findByExternalIdAndConsentStatusIn(consentId, EnumSet.of(CmsConsentStatus.RECEIVED, CmsConsentStatus.VALID)));
    }

    private Optional<AisConsent> getAisConsentById(String consentId) {
        return Optional.ofNullable(consentId).flatMap(arg_0 -> ((AisConsentRepository)this.aisConsentRepository).findByExternalId(arg_0));
    }

    private AisConsent checkAndUpdateOnExpiration(AisConsent consent) {
        if (consent != null && consent.isExpiredByDate() && consent.isStatusNotExpired()) {
            consent.setConsentStatus(CmsConsentStatus.EXPIRED);
            consent.setExpireDate(LocalDate.now());
            consent.setLastActionDate(LocalDate.now());
            this.aisConsentRepository.save((Object)consent);
        }
        return consent;
    }

    private AisConsent setStatusAndSaveConsent(AisConsent consent, CmsConsentStatus status) {
        consent.setLastActionDate(LocalDate.now());
        consent.setConsentStatus(status);
        return (AisConsent)this.aisConsentRepository.save((Object)consent);
    }

    private String saveNewAuthorization(AisConsent aisConsent, AisConsentAuthorizationRequest request) {
        AisConsentAuthorization consentAuthorization = new AisConsentAuthorization();
        consentAuthorization.setExternalId(UUID.randomUUID().toString());
        consentAuthorization.setPsuId(request.getPsuId());
        consentAuthorization.setConsent(aisConsent);
        consentAuthorization.setScaStatus(request.getScaStatus());
        return ((AisConsentAuthorization)this.aisConsentAuthorizationRepository.save((Object)consentAuthorization)).getExternalId();
    }

    private Optional<Boolean> updateConsentAuthorization(String authorizationId, AisConsentAuthorizationRequest request) {
        return this.aisConsentAuthorizationRepository.findByExternalId(authorizationId).map(conAuth -> {
            if (CmsScaStatus.STARTED == conAuth.getScaStatus()) {
                conAuth.setPsuId(request.getPsuId());
                conAuth.setPassword(request.getPassword());
            }
            if (CmsScaStatus.SCAMETHODSELECTED == request.getScaStatus()) {
                conAuth.setAuthenticationMethodId(request.getAuthenticationMethodId());
            }
            conAuth.setScaStatus(request.getScaStatus());
            return ((AisConsentAuthorization)this.aisConsentAuthorizationRepository.save(conAuth)).getExternalId() != null;
        });
    }

    @ConstructorProperties(value={"aisConsentRepository", "aisConsentActionRepository", "aisConsentAuthorizationRepository", "consentMapper", "frequencyPerDateCalculationService"})
    public AisConsentService(AisConsentRepository aisConsentRepository, AisConsentActionRepository aisConsentActionRepository, AisConsentAuthorizationRepository aisConsentAuthorizationRepository, AisConsentMapper consentMapper, FrequencyPerDateCalculationService frequencyPerDateCalculationService) {
        this.aisConsentRepository = aisConsentRepository;
        this.aisConsentActionRepository = aisConsentActionRepository;
        this.aisConsentAuthorizationRepository = aisConsentAuthorizationRepository;
        this.consentMapper = consentMapper;
        this.frequencyPerDateCalculationService = frequencyPerDateCalculationService;
    }
}

