/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.schedule;

import de.adorsys.aspsp.xs2a.consent.api.CmsConsentStatus;
import de.adorsys.aspsp.xs2a.domain.AisConsent;
import de.adorsys.aspsp.xs2a.repository.AisConsentRepository;
import de.adorsys.aspsp.xs2a.service.FrequencyPerDateCalculationService;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ConsentScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(ConsentScheduleTask.class);
    private final AisConsentRepository aisConsentRepository;
    private final FrequencyPerDateCalculationService frequencyPerDateCalculationService;

    @Scheduled(cron="${consent.cron.expression}")
    public void checkConsentStatus() {
        log.info("Consent schedule task is run!");
        List availableConsents = Optional.ofNullable(this.aisConsentRepository.findByConsentStatusIn(EnumSet.of(CmsConsentStatus.RECEIVED, CmsConsentStatus.VALID))).orElse(Collections.emptyList());
        this.aisConsentRepository.save((Iterable)this.updateConsent(availableConsents));
    }

    private List<AisConsent> updateConsent(List<AisConsent> availableConsents) {
        return availableConsents.stream().map(arg_0 -> this.updateConsentParameters(arg_0)).collect(Collectors.toList());
    }

    private AisConsent updateConsentParameters(AisConsent consent) {
        int minFrequencyPerDay = this.frequencyPerDateCalculationService.getMinFrequencyPerDay(consent.getTppFrequencyPerDay());
        consent.setExpectedFrequencyPerDay(minFrequencyPerDay);
        consent.setUsageCounter(minFrequencyPerDay);
        consent.setConsentStatus(this.updateConsentStatus(consent));
        return consent;
    }

    private CmsConsentStatus updateConsentStatus(AisConsent consent) {
        return consent.isExpiredByDate() ? CmsConsentStatus.EXPIRED : consent.getConsentStatus();
    }

    @ConstructorProperties(value={"aisConsentRepository", "frequencyPerDateCalculationService"})
    public ConsentScheduleTask(AisConsentRepository aisConsentRepository, FrequencyPerDateCalculationService frequencyPerDateCalculationService) {
        this.aisConsentRepository = aisConsentRepository;
        this.frequencyPerDateCalculationService = frequencyPerDateCalculationService;
    }
}

