/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain.pis;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.aspsp.xs2a.domain.pis.PisAccountReference;
import de.adorsys.aspsp.xs2a.domain.pis.PisAddress;
import de.adorsys.aspsp.xs2a.domain.pis.PisConsent;
import de.adorsys.aspsp.xs2a.domain.pis.PisRemittance;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Currency;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SequenceGenerator;

@Entity(name="pis_payment_data")
@ApiModel(description="pis payment entity", value="PisPaymentData")
public class PisPaymentData {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="pis_payment_data_generator")
    @SequenceGenerator(name="pis_payment_data_generator", sequenceName="pis_payment_data_id_seq")
    private Long id;
    @Column(name="payment_id", nullable=false)
    private String paymentId;
    @Column(name="end_to_end_identification")
    @ApiModelProperty(value="End to end identification", example="RI-123456789")
    private String endToEndIdentification;
    @PrimaryKeyJoinColumn
    @ManyToOne(cascade={CascadeType.ALL})
    @ApiModelProperty(value="Debtor account", required=true)
    private PisAccountReference debtorAccount;
    @Column(name="ultimate_debtor", nullable=false)
    @ApiModelProperty(value="Name of the ultimate debtor", required=true, example="Mueller")
    private String ultimateDebtor;
    @Column(name="currency", nullable=false)
    @ApiModelProperty(value="Iso currency code", required=true, example="EUR")
    private Currency currency;
    @Column(name="amount", nullable=false)
    @ApiModelProperty(value="Payment amount", required=true, example="1000")
    private BigDecimal amount;
    @PrimaryKeyJoinColumn
    @ManyToOne(cascade={CascadeType.ALL})
    @ApiModelProperty(value="Creditor account", required=true)
    private PisAccountReference creditorAccount;
    @Column(name="creditor_agent")
    @ApiModelProperty(value="Creditor agent", example="Telekom")
    private String creditorAgent;
    @Column(name="creditor_name", nullable=false)
    @ApiModelProperty(value="Name of the creditor", required=true, example="Telekom")
    private String creditorName;
    @OneToOne(cascade={CascadeType.ALL})
    @ApiModelProperty(value="Creditor Address")
    @JoinColumn(name="address_id")
    private PisAddress creditorAddress;
    @Column(name="remittance_information_unstructured")
    @ApiModelProperty(value="remittance information unstructured", example="Ref. Number TELEKOM-1222")
    private String remittanceInformationUnstructured;
    @OneToOne(cascade={CascadeType.ALL})
    @ApiModelProperty(value="remittance information structured")
    @JoinColumn(name="remittance_id")
    private PisRemittance remittanceInformationStructured;
    @Column(name="requested_execution_date", nullable=false)
    @ApiModelProperty(value="Requested execution date", required=true, example="2020-01-01")
    private LocalDate requestedExecutionDate;
    @Column(name="requested_execution_time", nullable=false)
    @ApiModelProperty(value="Requested execution time", required=true, example="2020-01-01T15:30:35.035Z")
    private LocalDateTime requestedExecutionTime;
    @Column(name="ultimate_creditor")
    @ApiModelProperty(value="Ultimate creditor", example="Telekom")
    private String ultimateCreditor;
    @Column(name="purpose_code")
    @ApiModelProperty(value="Purpose code", example="BCENECEQ")
    private String purposeCode;
    @Column(name="start_date")
    @ApiModelProperty(name="startDate", example="2020-01-01")
    private LocalDate startDate;
    @Column(name="execution_rule")
    @ApiModelProperty(name="Execution rule", example="latest")
    private String executionRule;
    @Column(name="end_date")
    @ApiModelProperty(name="endDate", example="2020-03-03")
    private LocalDate endDate;
    @ApiModelProperty(name="frequency", example="ANNUAL")
    private String frequency;
    @Column(name="day_of_execution")
    @ApiModelProperty(name="dayOfExecution", example="14")
    private int dayOfExecution;
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="consent_id", nullable=false)
    @ApiModelProperty(value="Detailed information about consent", required=true)
    private PisConsent consent;

    public Long getId() {
        return this.id;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public PisAccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public String getUltimateDebtor() {
        return this.ultimateDebtor;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public PisAccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public String getCreditorAgent() {
        return this.creditorAgent;
    }

    public String getCreditorName() {
        return this.creditorName;
    }

    public PisAddress getCreditorAddress() {
        return this.creditorAddress;
    }

    public String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    public PisRemittance getRemittanceInformationStructured() {
        return this.remittanceInformationStructured;
    }

    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public LocalDateTime getRequestedExecutionTime() {
        return this.requestedExecutionTime;
    }

    public String getUltimateCreditor() {
        return this.ultimateCreditor;
    }

    public String getPurposeCode() {
        return this.purposeCode;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public String getExecutionRule() {
        return this.executionRule;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public int getDayOfExecution() {
        return this.dayOfExecution;
    }

    public PisConsent getConsent() {
        return this.consent;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public void setDebtorAccount(PisAccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public void setUltimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setCreditorAccount(PisAccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public void setCreditorAddress(PisAddress creditorAddress) {
        this.creditorAddress = creditorAddress;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    public void setRemittanceInformationStructured(PisRemittance remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public void setRequestedExecutionTime(LocalDateTime requestedExecutionTime) {
        this.requestedExecutionTime = requestedExecutionTime;
    }

    public void setUltimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
    }

    public void setPurposeCode(String purposeCode) {
        this.purposeCode = purposeCode;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public void setExecutionRule(String executionRule) {
        this.executionRule = executionRule;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public void setDayOfExecution(int dayOfExecution) {
        this.dayOfExecution = dayOfExecution;
    }

    public void setConsent(PisConsent consent) {
        this.consent = consent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PisPaymentData)) {
            return false;
        }
        PisPaymentData other = (PisPaymentData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        String this$endToEndIdentification = this.getEndToEndIdentification();
        String other$endToEndIdentification = other.getEndToEndIdentification();
        if (this$endToEndIdentification == null ? other$endToEndIdentification != null : !this$endToEndIdentification.equals(other$endToEndIdentification)) {
            return false;
        }
        PisAccountReference this$debtorAccount = this.getDebtorAccount();
        PisAccountReference other$debtorAccount = other.getDebtorAccount();
        if (this$debtorAccount == null ? other$debtorAccount != null : !this$debtorAccount.equals(other$debtorAccount)) {
            return false;
        }
        String this$ultimateDebtor = this.getUltimateDebtor();
        String other$ultimateDebtor = other.getUltimateDebtor();
        if (this$ultimateDebtor == null ? other$ultimateDebtor != null : !this$ultimateDebtor.equals(other$ultimateDebtor)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        PisAccountReference this$creditorAccount = this.getCreditorAccount();
        PisAccountReference other$creditorAccount = other.getCreditorAccount();
        if (this$creditorAccount == null ? other$creditorAccount != null : !this$creditorAccount.equals(other$creditorAccount)) {
            return false;
        }
        String this$creditorAgent = this.getCreditorAgent();
        String other$creditorAgent = other.getCreditorAgent();
        if (this$creditorAgent == null ? other$creditorAgent != null : !this$creditorAgent.equals(other$creditorAgent)) {
            return false;
        }
        String this$creditorName = this.getCreditorName();
        String other$creditorName = other.getCreditorName();
        if (this$creditorName == null ? other$creditorName != null : !this$creditorName.equals(other$creditorName)) {
            return false;
        }
        PisAddress this$creditorAddress = this.getCreditorAddress();
        PisAddress other$creditorAddress = other.getCreditorAddress();
        if (this$creditorAddress == null ? other$creditorAddress != null : !this$creditorAddress.equals(other$creditorAddress)) {
            return false;
        }
        String this$remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        String other$remittanceInformationUnstructured = other.getRemittanceInformationUnstructured();
        if (this$remittanceInformationUnstructured == null ? other$remittanceInformationUnstructured != null : !this$remittanceInformationUnstructured.equals(other$remittanceInformationUnstructured)) {
            return false;
        }
        PisRemittance this$remittanceInformationStructured = this.getRemittanceInformationStructured();
        PisRemittance other$remittanceInformationStructured = other.getRemittanceInformationStructured();
        if (this$remittanceInformationStructured == null ? other$remittanceInformationStructured != null : !this$remittanceInformationStructured.equals(other$remittanceInformationStructured)) {
            return false;
        }
        LocalDate this$requestedExecutionDate = this.getRequestedExecutionDate();
        LocalDate other$requestedExecutionDate = other.getRequestedExecutionDate();
        if (this$requestedExecutionDate == null ? other$requestedExecutionDate != null : !((Object)this$requestedExecutionDate).equals(other$requestedExecutionDate)) {
            return false;
        }
        LocalDateTime this$requestedExecutionTime = this.getRequestedExecutionTime();
        LocalDateTime other$requestedExecutionTime = other.getRequestedExecutionTime();
        if (this$requestedExecutionTime == null ? other$requestedExecutionTime != null : !((Object)this$requestedExecutionTime).equals(other$requestedExecutionTime)) {
            return false;
        }
        String this$ultimateCreditor = this.getUltimateCreditor();
        String other$ultimateCreditor = other.getUltimateCreditor();
        if (this$ultimateCreditor == null ? other$ultimateCreditor != null : !this$ultimateCreditor.equals(other$ultimateCreditor)) {
            return false;
        }
        String this$purposeCode = this.getPurposeCode();
        String other$purposeCode = other.getPurposeCode();
        if (this$purposeCode == null ? other$purposeCode != null : !this$purposeCode.equals(other$purposeCode)) {
            return false;
        }
        LocalDate this$startDate = this.getStartDate();
        LocalDate other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        String this$executionRule = this.getExecutionRule();
        String other$executionRule = other.getExecutionRule();
        if (this$executionRule == null ? other$executionRule != null : !this$executionRule.equals(other$executionRule)) {
            return false;
        }
        LocalDate this$endDate = this.getEndDate();
        LocalDate other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        String this$frequency = this.getFrequency();
        String other$frequency = other.getFrequency();
        if (this$frequency == null ? other$frequency != null : !this$frequency.equals(other$frequency)) {
            return false;
        }
        if (this.getDayOfExecution() != other.getDayOfExecution()) {
            return false;
        }
        PisConsent this$consent = this.getConsent();
        PisConsent other$consent = other.getConsent();
        return !(this$consent == null ? other$consent != null : !this$consent.equals(other$consent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PisPaymentData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        String $endToEndIdentification = this.getEndToEndIdentification();
        result = result * 59 + ($endToEndIdentification == null ? 43 : $endToEndIdentification.hashCode());
        PisAccountReference $debtorAccount = this.getDebtorAccount();
        result = result * 59 + ($debtorAccount == null ? 43 : $debtorAccount.hashCode());
        String $ultimateDebtor = this.getUltimateDebtor();
        result = result * 59 + ($ultimateDebtor == null ? 43 : $ultimateDebtor.hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        PisAccountReference $creditorAccount = this.getCreditorAccount();
        result = result * 59 + ($creditorAccount == null ? 43 : $creditorAccount.hashCode());
        String $creditorAgent = this.getCreditorAgent();
        result = result * 59 + ($creditorAgent == null ? 43 : $creditorAgent.hashCode());
        String $creditorName = this.getCreditorName();
        result = result * 59 + ($creditorName == null ? 43 : $creditorName.hashCode());
        PisAddress $creditorAddress = this.getCreditorAddress();
        result = result * 59 + ($creditorAddress == null ? 43 : $creditorAddress.hashCode());
        String $remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        result = result * 59 + ($remittanceInformationUnstructured == null ? 43 : $remittanceInformationUnstructured.hashCode());
        PisRemittance $remittanceInformationStructured = this.getRemittanceInformationStructured();
        result = result * 59 + ($remittanceInformationStructured == null ? 43 : $remittanceInformationStructured.hashCode());
        LocalDate $requestedExecutionDate = this.getRequestedExecutionDate();
        result = result * 59 + ($requestedExecutionDate == null ? 43 : ((Object)$requestedExecutionDate).hashCode());
        LocalDateTime $requestedExecutionTime = this.getRequestedExecutionTime();
        result = result * 59 + ($requestedExecutionTime == null ? 43 : ((Object)$requestedExecutionTime).hashCode());
        String $ultimateCreditor = this.getUltimateCreditor();
        result = result * 59 + ($ultimateCreditor == null ? 43 : $ultimateCreditor.hashCode());
        String $purposeCode = this.getPurposeCode();
        result = result * 59 + ($purposeCode == null ? 43 : $purposeCode.hashCode());
        LocalDate $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        String $executionRule = this.getExecutionRule();
        result = result * 59 + ($executionRule == null ? 43 : $executionRule.hashCode());
        LocalDate $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        String $frequency = this.getFrequency();
        result = result * 59 + ($frequency == null ? 43 : $frequency.hashCode());
        result = result * 59 + this.getDayOfExecution();
        PisConsent $consent = this.getConsent();
        result = result * 59 + ($consent == null ? 43 : $consent.hashCode());
        return result;
    }

    public String toString() {
        return "PisPaymentData(id=" + this.getId() + ", paymentId=" + this.getPaymentId() + ", endToEndIdentification=" + this.getEndToEndIdentification() + ", debtorAccount=" + this.getDebtorAccount() + ", ultimateDebtor=" + this.getUltimateDebtor() + ", currency=" + this.getCurrency() + ", amount=" + this.getAmount() + ", creditorAccount=" + this.getCreditorAccount() + ", creditorAgent=" + this.getCreditorAgent() + ", creditorName=" + this.getCreditorName() + ", creditorAddress=" + this.getCreditorAddress() + ", remittanceInformationUnstructured=" + this.getRemittanceInformationUnstructured() + ", remittanceInformationStructured=" + this.getRemittanceInformationStructured() + ", requestedExecutionDate=" + this.getRequestedExecutionDate() + ", requestedExecutionTime=" + this.getRequestedExecutionTime() + ", ultimateCreditor=" + this.getUltimateCreditor() + ", purposeCode=" + this.getPurposeCode() + ", startDate=" + this.getStartDate() + ", executionRule=" + this.getExecutionRule() + ", endDate=" + this.getEndDate() + ", frequency=" + this.getFrequency() + ", dayOfExecution=" + this.getDayOfExecution() + ", consent=" + this.getConsent() + ")";
    }
}

