/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain.pis;

import de.adorsys.aspsp.xs2a.consent.api.CmsConsentStatus;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisPaymentProduct;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisPaymentType;
import de.adorsys.aspsp.xs2a.domain.ConsentType;
import de.adorsys.aspsp.xs2a.domain.pis.PisPaymentData;
import de.adorsys.aspsp.xs2a.domain.pis.PisTppInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import org.hibernate.annotations.Type;

@Entity(name="pis_consent")
@ApiModel(description="Pis consent entity", value="PisConsent")
public class PisConsent {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="pis_consent_generator")
    @SequenceGenerator(name="pis_consent_generator", sequenceName="pis_consent_id_seq")
    private Long id;
    @Column(name="external_id", nullable=false)
    @ApiModelProperty(value="An external exposed identification of the created payment consent", required=true, example="bf489af6-a2cb-4b75-b71d-d66d58b934d7")
    private String externalId;
    @OneToMany(mappedBy="consent", cascade={CascadeType.ALL}, orphanRemoval=true)
    @ApiModelProperty(value="List of single payments ", required=true)
    private List<PisPaymentData> payments = new ArrayList();
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="tpp_info_id")
    @ApiModelProperty(value="Information about TPP", required=true)
    private PisTppInfo pisTppInfo;
    @Column(name="payment_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Payment type: BULK, SINGLE or PERIODIC.", required=true, example="SINGLE")
    private PisPaymentType pisPaymentType;
    @Column(name="payment_product", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Payment product", required=true, example="sepa-credit-transfers")
    private PisPaymentProduct pisPaymentProduct;
    @Column(name="consent_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Type of the consent: AIS or PIS.", required=true, example="AIS")
    private ConsentType consentType = ConsentType.PIS;
    @Column(name="consent_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="The following code values are permitted 'received', 'valid', 'rejected', 'expired', 'revoked by psu', 'terminated by tpp'. These values might be extended by ASPSP.", required=true, example="VALID")
    private CmsConsentStatus consentStatus;
    @Lob
    @Column(name="aspsp_consent_data")
    @Type(type="org.hibernate.type.BinaryType")
    private byte[] aspspConsentData;

    public void addPaymentsData(List<PisPaymentData> pisPaymentsData) {
        pisPaymentsData.forEach(arg_0 -> this.addPisPaymentData(arg_0));
    }

    private void addPisPaymentData(PisPaymentData pisPaymentData) {
        this.payments.add(pisPaymentData);
        pisPaymentData.setConsent(this);
    }

    public Long getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public List<PisPaymentData> getPayments() {
        return this.payments;
    }

    public PisTppInfo getPisTppInfo() {
        return this.pisTppInfo;
    }

    public PisPaymentType getPisPaymentType() {
        return this.pisPaymentType;
    }

    public PisPaymentProduct getPisPaymentProduct() {
        return this.pisPaymentProduct;
    }

    public ConsentType getConsentType() {
        return this.consentType;
    }

    public CmsConsentStatus getConsentStatus() {
        return this.consentStatus;
    }

    public byte[] getAspspConsentData() {
        return this.aspspConsentData;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setPayments(List<PisPaymentData> payments) {
        this.payments = payments;
    }

    public void setPisTppInfo(PisTppInfo pisTppInfo) {
        this.pisTppInfo = pisTppInfo;
    }

    public void setPisPaymentType(PisPaymentType pisPaymentType) {
        this.pisPaymentType = pisPaymentType;
    }

    public void setPisPaymentProduct(PisPaymentProduct pisPaymentProduct) {
        this.pisPaymentProduct = pisPaymentProduct;
    }

    public void setConsentType(ConsentType consentType) {
        this.consentType = consentType;
    }

    public void setConsentStatus(CmsConsentStatus consentStatus) {
        this.consentStatus = consentStatus;
    }

    public void setAspspConsentData(byte[] aspspConsentData) {
        this.aspspConsentData = aspspConsentData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PisConsent)) {
            return false;
        }
        PisConsent other = (PisConsent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        List this$payments = this.getPayments();
        List other$payments = other.getPayments();
        if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
            return false;
        }
        PisTppInfo this$pisTppInfo = this.getPisTppInfo();
        PisTppInfo other$pisTppInfo = other.getPisTppInfo();
        if (this$pisTppInfo == null ? other$pisTppInfo != null : !this$pisTppInfo.equals(other$pisTppInfo)) {
            return false;
        }
        PisPaymentType this$pisPaymentType = this.getPisPaymentType();
        PisPaymentType other$pisPaymentType = other.getPisPaymentType();
        if (this$pisPaymentType == null ? other$pisPaymentType != null : !this$pisPaymentType.equals(other$pisPaymentType)) {
            return false;
        }
        PisPaymentProduct this$pisPaymentProduct = this.getPisPaymentProduct();
        PisPaymentProduct other$pisPaymentProduct = other.getPisPaymentProduct();
        if (this$pisPaymentProduct == null ? other$pisPaymentProduct != null : !this$pisPaymentProduct.equals(other$pisPaymentProduct)) {
            return false;
        }
        ConsentType this$consentType = this.getConsentType();
        ConsentType other$consentType = other.getConsentType();
        if (this$consentType == null ? other$consentType != null : !this$consentType.equals(other$consentType)) {
            return false;
        }
        CmsConsentStatus this$consentStatus = this.getConsentStatus();
        CmsConsentStatus other$consentStatus = other.getConsentStatus();
        if (this$consentStatus == null ? other$consentStatus != null : !this$consentStatus.equals(other$consentStatus)) {
            return false;
        }
        return Arrays.equals(this.getAspspConsentData(), other.getAspspConsentData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof PisConsent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        List $payments = this.getPayments();
        result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
        PisTppInfo $pisTppInfo = this.getPisTppInfo();
        result = result * 59 + ($pisTppInfo == null ? 43 : $pisTppInfo.hashCode());
        PisPaymentType $pisPaymentType = this.getPisPaymentType();
        result = result * 59 + ($pisPaymentType == null ? 43 : $pisPaymentType.hashCode());
        PisPaymentProduct $pisPaymentProduct = this.getPisPaymentProduct();
        result = result * 59 + ($pisPaymentProduct == null ? 43 : $pisPaymentProduct.hashCode());
        ConsentType $consentType = this.getConsentType();
        result = result * 59 + ($consentType == null ? 43 : $consentType.hashCode());
        CmsConsentStatus $consentStatus = this.getConsentStatus();
        result = result * 59 + ($consentStatus == null ? 43 : $consentStatus.hashCode());
        result = result * 59 + Arrays.hashCode(this.getAspspConsentData());
        return result;
    }

    public String toString() {
        return "PisConsent(id=" + this.getId() + ", externalId=" + this.getExternalId() + ", payments=" + this.getPayments() + ", pisTppInfo=" + this.getPisTppInfo() + ", pisPaymentType=" + this.getPisPaymentType() + ", pisPaymentProduct=" + this.getPisPaymentProduct() + ", consentType=" + this.getConsentType() + ", consentStatus=" + this.getConsentStatus() + ", aspspConsentData=" + Arrays.toString(this.getAspspConsentData()) + ")";
    }
}

