/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain;

import de.adorsys.aspsp.xs2a.consent.api.TypeAccess;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Currency;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;

@Embeddable
@ApiModel(description="Account access", value="AccountAccess")
public class AccountAccess {
    @Column(name="iban", nullable=false, length=34)
    @ApiModelProperty(value="IBAN: This data element can be used in the body of the CreateConsentReq Request Message for retrieving account access consent from this payment account", required=true, example="DE2310010010123456789")
    private String iban;
    @Column(name="currency", length=3)
    @ApiModelProperty(value="Currency Type", required=true, example="EUR")
    private Currency currency;
    @Column(name="type_access", nullable=false, length=15)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Types of given accesses: account, balance, transaction, payment", required=true, example="ACCOUNT")
    private TypeAccess typeAccess;

    public AccountAccess() {
    }

    public AccountAccess(String iban, Currency currency, TypeAccess typeAccess) {
        this.iban = iban;
        this.currency = currency;
        this.typeAccess = typeAccess;
    }

    public String getIban() {
        return this.iban;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public TypeAccess getTypeAccess() {
        return this.typeAccess;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setTypeAccess(TypeAccess typeAccess) {
        this.typeAccess = typeAccess;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountAccess)) {
            return false;
        }
        AccountAccess other = (AccountAccess)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$iban = this.getIban();
        String other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        TypeAccess this$typeAccess = this.getTypeAccess();
        TypeAccess other$typeAccess = other.getTypeAccess();
        return !(this$typeAccess == null ? other$typeAccess != null : !this$typeAccess.equals(other$typeAccess));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountAccess;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $iban = this.getIban();
        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        TypeAccess $typeAccess = this.getTypeAccess();
        result = result * 59 + ($typeAccess == null ? 43 : $typeAccess.hashCode());
        return result;
    }

    public String toString() {
        return "AccountAccess(iban=" + this.getIban() + ", currency=" + this.getCurrency() + ", typeAccess=" + this.getTypeAccess() + ")";
    }
}

