/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.account;

import de.adorsys.aspsp.xs2a.consent.api.AccountInfo;
import de.adorsys.aspsp.xs2a.consent.api.TypeAccess;
import de.adorsys.aspsp.xs2a.domain.AccountAccess;
import java.util.Currency;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public final class AccountAccessHolder {
    private final Set<AccountAccess> accountAccesses = new HashSet();

    public void fillAccess(List<AccountInfo> info, TypeAccess typeAccess) {
        if (CollectionUtils.isNotEmpty(info)) {
            for (AccountInfo a : info) {
                this.addAccountAccess(a.getIban(), this.getCurrencyByString(a.getCurrency()), typeAccess);
            }
        }
    }

    private Currency getCurrencyByString(String currency) {
        return Optional.ofNullable(currency).map(Currency::getInstance).orElse(null);
    }

    private void addAccountAccess(String iban, Currency currency, TypeAccess typeAccess) {
        this.accountAccesses.add(new AccountAccess(iban, currency, typeAccess));
        if (EnumSet.of(TypeAccess.BALANCE, TypeAccess.TRANSACTION).contains(typeAccess)) {
            this.accountAccesses.add(new AccountAccess(iban, currency, TypeAccess.ACCOUNT));
        }
    }

    public Set<AccountAccess> getAccountAccesses() {
        return this.accountAccesses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountAccessHolder)) {
            return false;
        }
        AccountAccessHolder other = (AccountAccessHolder)o;
        Set this$accountAccesses = this.getAccountAccesses();
        Set other$accountAccesses = other.getAccountAccesses();
        return !(this$accountAccesses == null ? other$accountAccesses != null : !((Object)this$accountAccesses).equals(other$accountAccesses));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set $accountAccesses = this.getAccountAccesses();
        result = result * 59 + ($accountAccesses == null ? 43 : ((Object)$accountAccesses).hashCode());
        return result;
    }

    public String toString() {
        return "AccountAccessHolder(accountAccesses=" + this.getAccountAccesses() + ")";
    }
}

