/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web;

import de.adorsys.aspsp.xs2a.consent.api.ConsentActionRequest;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisConsentRequest;
import de.adorsys.aspsp.xs2a.service.AISConsentService;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiConsentStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"ais/consent"})
@Api(value="ais/consent", tags={"AIS, Consents"}, description="Provides access to consent management system for AIS")
public class AisConsentController {
    private final AISConsentService aisConsentService;

    @PostMapping(path={"/"})
    @ApiOperation(value="Create consent for given psu id and accesses.")
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=String.class), @ApiResponse(code=204, message="No Content")})
    public ResponseEntity<String> createConsent(@RequestBody AisConsentRequest request) {
        return this.aisConsentService.createConsent(request).map(consentId -> new ResponseEntity(consentId, HttpStatus.CREATED)).orElse(new ResponseEntity(HttpStatus.NO_CONTENT));
    }

    @PostMapping(path={"/action"})
    @ApiOperation(value="Save information about uses of consent")
    public ResponseEntity<Void> saveConsentActionLog(@RequestBody ConsentActionRequest request) {
        this.aisConsentService.checkConsentAndSaveActionLog(request);
        return ResponseEntity.ok().build();
    }

    @GetMapping(path={"/{consent-id}"})
    @ApiOperation(value="Read account consent by given consent id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=SpiAccountConsent.class), @ApiResponse(code=204, message="No Content")})
    public ResponseEntity<SpiAccountConsent> getConsentById(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId) {
        return this.aisConsentService.getSpiAccountConsentById(consentId).map(consent -> new ResponseEntity(consent, HttpStatus.OK)).orElse(new ResponseEntity(HttpStatus.NO_CONTENT));
    }

    @GetMapping(path={"/{consent-id}/status"})
    @ApiOperation(value="Can check the status of an account information consent resource.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=SpiConsentStatus.class), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<SpiConsentStatus> getConsentStatusById(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId) {
        return this.aisConsentService.getConsentStatusById(consentId).map(status -> new ResponseEntity(status, HttpStatus.OK)).orElse(new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @PutMapping(path={"/{consent-id}/status/{status}"})
    @ApiOperation(value="Update consent status in the consent identified by given consent id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Void> updateConsentStatus(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @ApiParam(value="The following code values are permitted 'VALID', 'REJECTED', 'REVOKED_BY_PSU', 'TERMINATED_BY_TPP'. These values might be extended by ASPSP by more values.", example="VALID") @PathVariable(value="status") String status) {
        return this.aisConsentService.updateConsentStatusById(consentId, SpiConsentStatus.valueOf((String)status)).map(updated -> new ResponseEntity(HttpStatus.OK)).orElse(new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @ConstructorProperties(value={"aisConsentService"})
    public AisConsentController(AISConsentService aisConsentService) {
        this.aisConsentService = aisConsentService;
    }
}

