/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service.mapper;

import de.adorsys.aspsp.xs2a.consent.api.TypeAccess;
import de.adorsys.aspsp.xs2a.domain.AisAccount;
import de.adorsys.aspsp.xs2a.domain.AisConsent;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiAccountAccess;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ConsentMapper {
    public SpiAccountConsent mapToSpiAccountConsent(AisConsent consent) {
        return new SpiAccountConsent(consent.getId().toString(), this.mapToSpiAccountAccess(consent.getAccounts()), consent.isRecurringIndicator(), consent.getExpireDate(), consent.getUsageCounter(), consent.getLastActionDate(), consent.getConsentStatus(), false, consent.isTppRedirectPreferred());
    }

    private SpiAccountAccess mapToSpiAccountAccess(List<AisAccount> aisAccounts) {
        return new SpiAccountAccess(this.mapToSpiAccountReference(aisAccounts, TypeAccess.ACCOUNT), this.mapToSpiAccountReference(aisAccounts, TypeAccess.BALANCE), this.mapToSpiAccountReference(aisAccounts, TypeAccess.TRANSACTION), null, null);
    }

    private List<SpiAccountReference> mapToSpiAccountReference(List<AisAccount> aisAccounts, TypeAccess typeAccess) {
        return aisAccounts.stream().map(acc -> this.mapToSpiAccountReference(acc, typeAccess)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<SpiAccountReference> mapToSpiAccountReference(AisAccount aisAccount, TypeAccess typeAccess) {
        return aisAccount.getAccesses().stream().filter(ass -> ass.getTypeAccess() == typeAccess).map(access -> new SpiAccountReference(aisAccount.getIban(), "", "", "", "", access.getCurrency())).collect(Collectors.toList());
    }
}

