/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.consent.api.pis.PisConsentStatus;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisConsentType;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentBulkPaymentRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentPeriodicPaymentRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentResponse;
import de.adorsys.aspsp.xs2a.domain.ConsentType;
import de.adorsys.aspsp.xs2a.domain.PisConsent;
import de.adorsys.aspsp.xs2a.repository.PisConsentRepository;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.stereotype.Service;

@Service
public class PISConsentService {
    private final PisConsentRepository pisConsentRepository;

    public Optional<String> createSinglePaymentConsent(PisConsentRequest request) {
        return this.mapToPisConsent(request.getPaymentId()).map(arg_0 -> ((PisConsentRepository)this.pisConsentRepository).save(arg_0)).map(PisConsent::getExternalId);
    }

    public Optional<String> createBulkPaymentConsent(PisConsentBulkPaymentRequest request) {
        return this.mapToBulkPaymentConsent(request.getPaymentIds()).map(arg_0 -> ((PisConsentRepository)this.pisConsentRepository).save(arg_0)).map(PisConsent::getExternalId);
    }

    public Optional<String> createPeriodicPaymentConsent(PisConsentPeriodicPaymentRequest request) {
        return this.mapToPeriodicPaymentConsent(request.getPeriodicPaymentId()).map(arg_0 -> ((PisConsentRepository)this.pisConsentRepository).save(arg_0)).map(PisConsent::getExternalId);
    }

    public Optional<PisConsentStatus> getConsentStatusById(String consentId) {
        return this.getPisConsentById(consentId).map(PisConsent::getConsentStatus);
    }

    public Optional<PisConsentResponse> getConsentById(String consentId) {
        return this.getPisConsentById(consentId).flatMap(arg_0 -> this.mapToPisConsentResponse(arg_0));
    }

    public Optional<Boolean> updateConsentStatusById(String consentId, PisConsentStatus status) {
        return this.getPisConsentById(consentId).map(con -> this.setStatusAndSaveConsent(con, status)).map(con -> con.getConsentStatus() == status);
    }

    private Optional<PisConsent> getPisConsentById(String consentId) {
        return Optional.ofNullable(consentId).flatMap(arg_0 -> ((PisConsentRepository)this.pisConsentRepository).findByExternalId(arg_0));
    }

    private PisConsent setStatusAndSaveConsent(PisConsent consent, PisConsentStatus status) {
        consent.setConsentStatus(status);
        return (PisConsent)this.pisConsentRepository.save((Object)consent);
    }

    private Optional<PisConsent> mapToBulkPaymentConsent(List<String> paymentIds) {
        PisConsent consent = new PisConsent();
        consent.setExternalId(UUID.randomUUID().toString());
        consent.setPaymentId(paymentIds);
        consent.setConsentType(ConsentType.PIS);
        consent.setPisConsentType(PisConsentType.BULK);
        consent.setConsentStatus(PisConsentStatus.RECEIVED);
        return Optional.of(consent);
    }

    private Optional<PisConsent> mapToPeriodicPaymentConsent(String periodicPaymentId) {
        return Optional.ofNullable(periodicPaymentId).map(pmt -> {
            PisConsent consent = new PisConsent();
            consent.setExternalId(UUID.randomUUID().toString());
            consent.setPaymentId(Collections.singletonList(pmt));
            consent.setConsentType(ConsentType.PIS);
            consent.setPisConsentType(PisConsentType.PERIODIC);
            consent.setConsentStatus(PisConsentStatus.RECEIVED);
            return consent;
        });
    }

    private Optional<PisConsent> mapToPisConsent(String paymentId) {
        return Optional.ofNullable(paymentId).map(pmt -> {
            PisConsent consent = new PisConsent();
            consent.setExternalId(UUID.randomUUID().toString());
            consent.setPaymentId(Collections.singletonList(pmt));
            consent.setConsentType(ConsentType.PIS);
            consent.setPisConsentType(PisConsentType.SINGLE);
            consent.setConsentStatus(PisConsentStatus.RECEIVED);
            return consent;
        });
    }

    private Optional<PisConsentResponse> mapToPisConsentResponse(PisConsent pisConsent) {
        return Optional.ofNullable(pisConsent).map(pc -> new PisConsentResponse(pc.getExternalId(), pc.getPisConsentType(), pc.getConsentStatus(), pc.getPaymentId()));
    }

    @ConstructorProperties(value={"pisConsentRepository"})
    public PISConsentService(PisConsentRepository pisConsentRepository) {
        this.pisConsentRepository = pisConsentRepository;
    }
}

