/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.schedule;

import de.adorsys.aspsp.xs2a.domain.AisConsent;
import de.adorsys.aspsp.xs2a.repository.AisConsentRepository;
import de.adorsys.aspsp.xs2a.service.AspspProfileService;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiConsentStatus;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ConsentScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(ConsentScheduleTask.class);
    private final AisConsentRepository aisConsentRepository;
    private final AspspProfileService profileService;

    @Scheduled(cron="${consent.cron.expression}")
    public void checkConsentStatus() {
        log.info("Consent schedule task is run!");
        List availableConsents = Optional.ofNullable(this.aisConsentRepository.findByConsentStatusIn(EnumSet.of(SpiConsentStatus.RECEIVED, SpiConsentStatus.VALID))).orElse(Collections.emptyList());
        this.aisConsentRepository.save((Iterable)this.updateConsent(availableConsents));
    }

    private List<AisConsent> updateConsent(List<AisConsent> availableConsents) {
        return availableConsents.stream().map(arg_0 -> this.updateConsentParameters(arg_0)).collect(Collectors.toList());
    }

    private AisConsent updateConsentParameters(AisConsent consent) {
        int minFrequencyPerDay = this.profileService.getMinFrequencyPerDay(consent.getTppFrequencyPerDay());
        consent.setExpectedFrequencyPerDay(minFrequencyPerDay);
        consent.setUsageCounter(minFrequencyPerDay);
        consent.setConsentStatus(this.updateConsentStatus(consent));
        return consent;
    }

    private SpiConsentStatus updateConsentStatus(AisConsent consent) {
        return consent.isExpiredByDate() ? SpiConsentStatus.EXPIRED : consent.getConsentStatus();
    }

    @ConstructorProperties(value={"aisConsentRepository", "profileService"})
    public ConsentScheduleTask(AisConsentRepository aisConsentRepository, AspspProfileService profileService) {
        this.aisConsentRepository = aisConsentRepository;
        this.profileService = profileService;
    }
}

