/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain;

import de.adorsys.aspsp.xs2a.consent.api.pis.PisConsentStatus;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisConsentType;
import de.adorsys.aspsp.xs2a.domain.ConsentType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.SequenceGenerator;

@Entity(name="pis_consent")
@ApiModel(description="Pis consent entity", value="PisConsent")
public class PisConsent {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="pis_consent_generator")
    @SequenceGenerator(name="pis_consent_generator", sequenceName="pis_consent_id_seq")
    private Long id;
    @Column(name="external_id", nullable=false)
    @ApiModelProperty(value="An external exposed identification of the created payment consent", required=true, example="bf489af6-a2cb-4b75-b71d-d66d58b934d7")
    private String externalId;
    @ElementCollection
    @CollectionTable(name="pis_payment", joinColumns={@JoinColumn(name="pis_consent_id")})
    @ApiModelProperty(value="List of payments ID", required=true)
    private List<String> paymentId;
    @Column(name="pis_consent_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Type of the pis consent: BULK, SINGLE or PERIODIC.", required=true, example="SINGLE")
    private PisConsentType pisConsentType;
    @Column(name="consent_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Type of the consent: AIS or PIS.", required=true, example="AIS")
    private ConsentType consentType = ConsentType.PIS;
    @Column(name="consent_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="The following code values are permitted 'received', 'valid', 'rejected', 'expired', 'revoked by psu', 'terminated by tpp'. These values might be extended by ASPSP.", required=true, example="VALID")
    private PisConsentStatus consentStatus;

    public Long getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public List<String> getPaymentId() {
        return this.paymentId;
    }

    public PisConsentType getPisConsentType() {
        return this.pisConsentType;
    }

    public ConsentType getConsentType() {
        return this.consentType;
    }

    public PisConsentStatus getConsentStatus() {
        return this.consentStatus;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setPaymentId(List<String> paymentId) {
        this.paymentId = paymentId;
    }

    public void setPisConsentType(PisConsentType pisConsentType) {
        this.pisConsentType = pisConsentType;
    }

    public void setConsentType(ConsentType consentType) {
        this.consentType = consentType;
    }

    public void setConsentStatus(PisConsentStatus consentStatus) {
        this.consentStatus = consentStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PisConsent)) {
            return false;
        }
        PisConsent other = (PisConsent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        List this$paymentId = this.getPaymentId();
        List other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !((Object)this$paymentId).equals(other$paymentId)) {
            return false;
        }
        PisConsentType this$pisConsentType = this.getPisConsentType();
        PisConsentType other$pisConsentType = other.getPisConsentType();
        if (this$pisConsentType == null ? other$pisConsentType != null : !this$pisConsentType.equals(other$pisConsentType)) {
            return false;
        }
        ConsentType this$consentType = this.getConsentType();
        ConsentType other$consentType = other.getConsentType();
        if (this$consentType == null ? other$consentType != null : !this$consentType.equals(other$consentType)) {
            return false;
        }
        PisConsentStatus this$consentStatus = this.getConsentStatus();
        PisConsentStatus other$consentStatus = other.getConsentStatus();
        return !(this$consentStatus == null ? other$consentStatus != null : !this$consentStatus.equals(other$consentStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PisConsent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        List $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : ((Object)$paymentId).hashCode());
        PisConsentType $pisConsentType = this.getPisConsentType();
        result = result * 59 + ($pisConsentType == null ? 43 : $pisConsentType.hashCode());
        ConsentType $consentType = this.getConsentType();
        result = result * 59 + ($consentType == null ? 43 : $consentType.hashCode());
        PisConsentStatus $consentStatus = this.getConsentStatus();
        result = result * 59 + ($consentStatus == null ? 43 : $consentStatus.hashCode());
        return result;
    }

    public String toString() {
        return "PisConsent(id=" + this.getId() + ", externalId=" + this.getExternalId() + ", paymentId=" + this.getPaymentId() + ", pisConsentType=" + this.getPisConsentType() + ", consentType=" + this.getConsentType() + ", consentStatus=" + this.getConsentStatus() + ")";
    }
}

