/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain;

import de.adorsys.aspsp.xs2a.domain.AisAccount;
import de.adorsys.aspsp.xs2a.domain.ConsentType;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiConsentStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;

@Entity(name="ais_consent")
@ApiModel(description="Ais consent entity", value="AisConsent")
public class AisConsent {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ais_consent_generator")
    @SequenceGenerator(name="ais_consent_generator", sequenceName="ais_consent_id_seq")
    private Long id;
    @Column(name="external_id", nullable=false)
    @ApiModelProperty(value="An external exposed identification of the created account consent", required=true, example="bf489af6-a2cb-4b75-b71d-d66d58b934d7")
    private String externalId;
    @Column(name="recurring_indicator", nullable=false)
    @ApiModelProperty(value="'true', if the consent is for recurring access to the account data , 'false', if the consent is for single access to the account data", required=true, example="false")
    private boolean recurringIndicator;
    @Column(name="tpp_redirect_preferred", nullable=false)
    @ApiModelProperty(name="tppRedirectPreferred", value="If it equals \u201ctrue\u201d, the TPP prefers a redirect over an embedded SCA approach.", required=true, example="false")
    private boolean tppRedirectPreferred;
    @Column(name="combined_service_indicator", nullable=false)
    @ApiModelProperty(value="'true' if aspsp supports combined sessions, otherwise 'false'.", required=true, example="false")
    private boolean combinedServiceIndicator;
    @Column(name="request_date_time", nullable=false)
    @ApiModelProperty(value="Date of the last request for this consent. The content is the local ASPSP date in ISODate Format", required=true, example="2018-10-25T15:30:35.035")
    private LocalDateTime requestDateTime;
    @Column(name="last_action_date")
    @ApiModelProperty(value="Date of the last action for this consent. The content is the local ASPSP date in ISODate Format", required=true, example="2018-05-04")
    private LocalDate lastActionDate;
    @Column(name="expire_date", nullable=false)
    @ApiModelProperty(value="Expiration date for the requested consent. The content is the local ASPSP date in ISODate Format", required=true, example="2018-05-04")
    private LocalDate expireDate;
    @Column(name="psu_id")
    @ApiModelProperty(value="Psu id", required=true, example="PSU_001")
    private String psuId;
    @Column(name="tpp_id", nullable=false, length=16)
    @ApiModelProperty(value="TPP id", required=true, example="af006545-d713-46d7-b6cf-09c9628f9a5d")
    private String tppId;
    @Column(name="consent_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="The following code values are permitted 'received', 'valid', 'rejected', 'expired', 'revoked by psu', 'terminated by tpp'. These values might be extended by ASPSP by more values.", required=true, example="VALID")
    private SpiConsentStatus consentStatus;
    @Column(name="consent_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Type of the consent: AIS or PIS.", required=true, example="AIS")
    private ConsentType consentType = ConsentType.AIS;
    @Column(name="expected_frequency_per_day", nullable=false)
    @ApiModelProperty(value="Maximum frequency for an access per day, based on tppFrequencyPerDate and inner calculations. For a once-off access, this attribute is set to 1", required=true, example="4")
    private int expectedFrequencyPerDay;
    @Column(name="tpp_frequency_per_day", nullable=false)
    @ApiModelProperty(value="Requested maximum frequency for an access per day. For a once-off access, this attribute is set to 1", required=true, example="4")
    private int tppFrequencyPerDay;
    @Column(name="usage_counter", nullable=false)
    @ApiModelProperty(value="Usage counter for the consent", required=true, example="7")
    private int usageCounter;
    @OneToMany(mappedBy="consent", cascade={CascadeType.PERSIST}, orphanRemoval=true)
    @ApiModelProperty(value="List of accounts related to the consent", required=true)
    private List<AisAccount> accounts = new ArrayList();

    public void addAccounts(List<AisAccount> accounts) {
        accounts.forEach(arg_0 -> this.addAccount(arg_0));
    }

    public boolean isExpiredByDate() {
        return LocalDate.now().compareTo(this.expireDate) >= 0;
    }

    public boolean isStatusNotExpired() {
        return this.consentStatus != SpiConsentStatus.EXPIRED;
    }

    public boolean hasUsagesAvailable() {
        return this.usageCounter > 0;
    }

    private void addAccount(AisAccount account) {
        this.accounts.add(account);
        account.setConsent(this);
    }

    public Long getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public boolean isRecurringIndicator() {
        return this.recurringIndicator;
    }

    public boolean isTppRedirectPreferred() {
        return this.tppRedirectPreferred;
    }

    public boolean isCombinedServiceIndicator() {
        return this.combinedServiceIndicator;
    }

    public LocalDateTime getRequestDateTime() {
        return this.requestDateTime;
    }

    public LocalDate getLastActionDate() {
        return this.lastActionDate;
    }

    public LocalDate getExpireDate() {
        return this.expireDate;
    }

    public String getPsuId() {
        return this.psuId;
    }

    public String getTppId() {
        return this.tppId;
    }

    public SpiConsentStatus getConsentStatus() {
        return this.consentStatus;
    }

    public ConsentType getConsentType() {
        return this.consentType;
    }

    public int getExpectedFrequencyPerDay() {
        return this.expectedFrequencyPerDay;
    }

    public int getTppFrequencyPerDay() {
        return this.tppFrequencyPerDay;
    }

    public int getUsageCounter() {
        return this.usageCounter;
    }

    public List<AisAccount> getAccounts() {
        return this.accounts;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setRecurringIndicator(boolean recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
    }

    public void setTppRedirectPreferred(boolean tppRedirectPreferred) {
        this.tppRedirectPreferred = tppRedirectPreferred;
    }

    public void setCombinedServiceIndicator(boolean combinedServiceIndicator) {
        this.combinedServiceIndicator = combinedServiceIndicator;
    }

    public void setRequestDateTime(LocalDateTime requestDateTime) {
        this.requestDateTime = requestDateTime;
    }

    public void setLastActionDate(LocalDate lastActionDate) {
        this.lastActionDate = lastActionDate;
    }

    public void setExpireDate(LocalDate expireDate) {
        this.expireDate = expireDate;
    }

    public void setPsuId(String psuId) {
        this.psuId = psuId;
    }

    public void setTppId(String tppId) {
        this.tppId = tppId;
    }

    public void setConsentStatus(SpiConsentStatus consentStatus) {
        this.consentStatus = consentStatus;
    }

    public void setConsentType(ConsentType consentType) {
        this.consentType = consentType;
    }

    public void setExpectedFrequencyPerDay(int expectedFrequencyPerDay) {
        this.expectedFrequencyPerDay = expectedFrequencyPerDay;
    }

    public void setTppFrequencyPerDay(int tppFrequencyPerDay) {
        this.tppFrequencyPerDay = tppFrequencyPerDay;
    }

    public void setUsageCounter(int usageCounter) {
        this.usageCounter = usageCounter;
    }

    public void setAccounts(List<AisAccount> accounts) {
        this.accounts = accounts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AisConsent)) {
            return false;
        }
        AisConsent other = (AisConsent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        if (this.isRecurringIndicator() != other.isRecurringIndicator()) {
            return false;
        }
        if (this.isTppRedirectPreferred() != other.isTppRedirectPreferred()) {
            return false;
        }
        if (this.isCombinedServiceIndicator() != other.isCombinedServiceIndicator()) {
            return false;
        }
        LocalDateTime this$requestDateTime = this.getRequestDateTime();
        LocalDateTime other$requestDateTime = other.getRequestDateTime();
        if (this$requestDateTime == null ? other$requestDateTime != null : !((Object)this$requestDateTime).equals(other$requestDateTime)) {
            return false;
        }
        LocalDate this$lastActionDate = this.getLastActionDate();
        LocalDate other$lastActionDate = other.getLastActionDate();
        if (this$lastActionDate == null ? other$lastActionDate != null : !((Object)this$lastActionDate).equals(other$lastActionDate)) {
            return false;
        }
        LocalDate this$expireDate = this.getExpireDate();
        LocalDate other$expireDate = other.getExpireDate();
        if (this$expireDate == null ? other$expireDate != null : !((Object)this$expireDate).equals(other$expireDate)) {
            return false;
        }
        String this$psuId = this.getPsuId();
        String other$psuId = other.getPsuId();
        if (this$psuId == null ? other$psuId != null : !this$psuId.equals(other$psuId)) {
            return false;
        }
        String this$tppId = this.getTppId();
        String other$tppId = other.getTppId();
        if (this$tppId == null ? other$tppId != null : !this$tppId.equals(other$tppId)) {
            return false;
        }
        SpiConsentStatus this$consentStatus = this.getConsentStatus();
        SpiConsentStatus other$consentStatus = other.getConsentStatus();
        if (this$consentStatus == null ? other$consentStatus != null : !this$consentStatus.equals(other$consentStatus)) {
            return false;
        }
        ConsentType this$consentType = this.getConsentType();
        ConsentType other$consentType = other.getConsentType();
        if (this$consentType == null ? other$consentType != null : !this$consentType.equals(other$consentType)) {
            return false;
        }
        if (this.getExpectedFrequencyPerDay() != other.getExpectedFrequencyPerDay()) {
            return false;
        }
        if (this.getTppFrequencyPerDay() != other.getTppFrequencyPerDay()) {
            return false;
        }
        if (this.getUsageCounter() != other.getUsageCounter()) {
            return false;
        }
        List this$accounts = this.getAccounts();
        List other$accounts = other.getAccounts();
        return !(this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AisConsent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        result = result * 59 + (this.isRecurringIndicator() ? 79 : 97);
        result = result * 59 + (this.isTppRedirectPreferred() ? 79 : 97);
        result = result * 59 + (this.isCombinedServiceIndicator() ? 79 : 97);
        LocalDateTime $requestDateTime = this.getRequestDateTime();
        result = result * 59 + ($requestDateTime == null ? 43 : ((Object)$requestDateTime).hashCode());
        LocalDate $lastActionDate = this.getLastActionDate();
        result = result * 59 + ($lastActionDate == null ? 43 : ((Object)$lastActionDate).hashCode());
        LocalDate $expireDate = this.getExpireDate();
        result = result * 59 + ($expireDate == null ? 43 : ((Object)$expireDate).hashCode());
        String $psuId = this.getPsuId();
        result = result * 59 + ($psuId == null ? 43 : $psuId.hashCode());
        String $tppId = this.getTppId();
        result = result * 59 + ($tppId == null ? 43 : $tppId.hashCode());
        SpiConsentStatus $consentStatus = this.getConsentStatus();
        result = result * 59 + ($consentStatus == null ? 43 : $consentStatus.hashCode());
        ConsentType $consentType = this.getConsentType();
        result = result * 59 + ($consentType == null ? 43 : $consentType.hashCode());
        result = result * 59 + this.getExpectedFrequencyPerDay();
        result = result * 59 + this.getTppFrequencyPerDay();
        result = result * 59 + this.getUsageCounter();
        List $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        return result;
    }

    public String toString() {
        return "AisConsent(id=" + this.getId() + ", externalId=" + this.getExternalId() + ", recurringIndicator=" + this.isRecurringIndicator() + ", tppRedirectPreferred=" + this.isTppRedirectPreferred() + ", combinedServiceIndicator=" + this.isCombinedServiceIndicator() + ", requestDateTime=" + this.getRequestDateTime() + ", lastActionDate=" + this.getLastActionDate() + ", expireDate=" + this.getExpireDate() + ", psuId=" + this.getPsuId() + ", tppId=" + this.getTppId() + ", consentStatus=" + this.getConsentStatus() + ", consentType=" + this.getConsentType() + ", expectedFrequencyPerDay=" + this.getExpectedFrequencyPerDay() + ", tppFrequencyPerDay=" + this.getTppFrequencyPerDay() + ", usageCounter=" + this.getUsageCounter() + ")";
    }
}

