/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web;

import de.adorsys.aspsp.xs2a.consent.api.pis.PisConsentStatus;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentBulkPaymentRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentPeriodicPaymentRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentResponse;
import de.adorsys.aspsp.xs2a.service.PISConsentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"pis/consent"})
@Api(value="pis/consent", tags={"PIS, Consents"}, description="Provides access to consent management system for PIS")
public class PisConsentController {
    private final PISConsentService pisConsentService;

    @PostMapping(path={"/"})
    @ApiOperation(value="", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<String> createSinglePaymentConsent(@RequestBody PisConsentRequest request) {
        return this.pisConsentService.createSinglePaymentConsent(request).map(consentId -> new ResponseEntity(consentId, HttpStatus.CREATED)).orElse(new ResponseEntity(HttpStatus.BAD_REQUEST));
    }

    @PostMapping(path={"/bulk"})
    @ApiOperation(value="", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<String> createBulkPaymentConsent(@RequestBody PisConsentBulkPaymentRequest request) {
        return this.pisConsentService.createBulkPaymentConsent(request).map(consentId -> new ResponseEntity(consentId, HttpStatus.CREATED)).orElse(new ResponseEntity(HttpStatus.BAD_REQUEST));
    }

    @PostMapping(path={"/periodic"})
    @ApiOperation(value="", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<String> createPeriodicPaymentConsent(@RequestBody PisConsentPeriodicPaymentRequest request) {
        return this.pisConsentService.createPeriodicPaymentConsent(request).map(consentId -> new ResponseEntity(consentId, HttpStatus.CREATED)).orElse(new ResponseEntity(HttpStatus.BAD_REQUEST));
    }

    @GetMapping(path={"/{consent-id}/status"})
    @ApiOperation(value="", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=PisConsentStatus.class), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<PisConsentStatus> getConsentStatusById(@ApiParam(name="consent-id", value="The payment consent identification assigned to the created payment consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId) {
        return this.pisConsentService.getConsentStatusById(consentId).map(status -> new ResponseEntity(status, HttpStatus.OK)).orElse(new ResponseEntity(HttpStatus.BAD_REQUEST));
    }

    @GetMapping(path={"/{consent-id}"})
    @ApiOperation(value="", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=PisConsentResponse.class), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<PisConsentResponse> getConsentById(@ApiParam(name="consent-id", value="The payment consent identification assigned to the created payment consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId) {
        return this.pisConsentService.getConsentById(consentId).map(pc -> new ResponseEntity(pc, HttpStatus.OK)).orElse(new ResponseEntity(HttpStatus.BAD_REQUEST));
    }

    @PutMapping(path={"/{consent-id}/status/{status}"})
    @ApiOperation(value="", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<Void> updateConsentStatus(@ApiParam(name="consent-id", value="The payment consent identification assigned to the created payment consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @ApiParam(value="The following code values are permitted 'received', 'valid', 'rejected', 'expired', 'revoked by psu', 'terminated by tpp'. These values might be extended by ASPSP by more values.", example="VALID") @PathVariable(value="status") String status) {
        return this.pisConsentService.updateConsentStatusById(consentId, PisConsentStatus.valueOf((String)status)).map(updated -> new ResponseEntity(HttpStatus.OK)).orElse(new ResponseEntity(HttpStatus.BAD_REQUEST));
    }

    @ConstructorProperties(value={"pisConsentService"})
    public PisConsentController(PISConsentService pisConsentService) {
        this.pisConsentService = pisConsentService;
    }
}

