/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.consent.api.pis.PisConsentStatus;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisConsentType;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisPayment;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisPeriodicPayment;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisSinglePayment;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentBulkPaymentRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentPeriodicPaymentRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentResponse;
import de.adorsys.aspsp.xs2a.domain.ConsentType;
import de.adorsys.aspsp.xs2a.domain.PisConsent;
import de.adorsys.aspsp.xs2a.domain.PisPaymentData;
import de.adorsys.aspsp.xs2a.repository.PisConsentRepository;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class PISConsentService {
    private final PisConsentRepository pisConsentRepository;

    public Optional<String> createSinglePaymentConsent(PisConsentRequest request) {
        return this.mapToPisConsent(request.getPisSinglePayment()).map(arg_0 -> ((PisConsentRepository)this.pisConsentRepository).save(arg_0)).map(PisConsent::getExternalId);
    }

    public Optional<String> createBulkPaymentConsent(PisConsentBulkPaymentRequest request) {
        return this.mapToBulkPaymentConsent(request.getPayments()).map(arg_0 -> ((PisConsentRepository)this.pisConsentRepository).save(arg_0)).map(PisConsent::getExternalId);
    }

    public Optional<String> createPeriodicPaymentConsent(PisConsentPeriodicPaymentRequest request) {
        return this.mapToPeriodicPaymentConsent(request.getPisPeriodicPayment()).map(arg_0 -> ((PisConsentRepository)this.pisConsentRepository).save(arg_0)).map(PisConsent::getExternalId);
    }

    public Optional<PisConsentStatus> getConsentStatusById(String consentId) {
        return this.getPisConsentById(consentId).map(PisConsent::getConsentStatus);
    }

    public Optional<PisConsentResponse> getConsentById(String consentId) {
        return this.getPisConsentById(consentId).flatMap(arg_0 -> this.mapToPisConsentResponse(arg_0));
    }

    public Optional<Boolean> updateConsentStatusById(String consentId, PisConsentStatus status) {
        return this.getPisConsentById(consentId).map(con -> this.setStatusAndSaveConsent(con, status)).map(con -> con.getConsentStatus() == status);
    }

    private Optional<PisConsent> getPisConsentById(String consentId) {
        return Optional.ofNullable(consentId).flatMap(arg_0 -> ((PisConsentRepository)this.pisConsentRepository).findByExternalId(arg_0));
    }

    private PisConsent setStatusAndSaveConsent(PisConsent consent, PisConsentStatus status) {
        consent.setConsentStatus(status);
        return (PisConsent)this.pisConsentRepository.save((Object)consent);
    }

    private Optional<PisConsent> mapToBulkPaymentConsent(List<PisSinglePayment> payments) {
        List paymentDataList = payments.stream().map(arg_0 -> this.mapToPisPaymentData(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        PisConsent consent = new PisConsent();
        consent.setExternalId(UUID.randomUUID().toString());
        consent.setPayments(paymentDataList);
        consent.setConsentType(ConsentType.PIS);
        consent.setPisConsentType(PisConsentType.BULK);
        consent.setConsentStatus(PisConsentStatus.RECEIVED);
        return Optional.of(consent);
    }

    private Optional<PisConsent> mapToPeriodicPaymentConsent(PisPeriodicPayment periodicPayment) {
        return Optional.ofNullable(periodicPayment).flatMap(arg_0 -> this.mapToPisPaymentData(arg_0)).map(pmt -> {
            PisConsent consent = new PisConsent();
            consent.setExternalId(UUID.randomUUID().toString());
            consent.setPayments(Collections.singletonList(pmt));
            consent.setConsentType(ConsentType.PIS);
            consent.setPisConsentType(PisConsentType.PERIODIC);
            consent.setConsentStatus(PisConsentStatus.RECEIVED);
            return consent;
        });
    }

    private Optional<PisConsent> mapToPisConsent(PisSinglePayment singlePayment) {
        return Optional.ofNullable(singlePayment).flatMap(arg_0 -> this.mapToPisPaymentData(arg_0)).map(pmt -> {
            PisConsent consent = new PisConsent();
            consent.setExternalId(UUID.randomUUID().toString());
            consent.setPayments(Collections.singletonList(pmt));
            consent.setConsentType(ConsentType.PIS);
            consent.setPisConsentType(PisConsentType.SINGLE);
            consent.setConsentStatus(PisConsentStatus.RECEIVED);
            return consent;
        });
    }

    private Optional<PisPaymentData> mapToPisPaymentData(PisSinglePayment singlePayment) {
        return Optional.ofNullable(singlePayment).map(sp -> {
            PisPaymentData payment = new PisPaymentData();
            payment.setEndToEndIdentification(sp.getEndToEndIdentification());
            payment.setDebtorIban(sp.getDebtorAccount().getIban());
            payment.setUltimateDebtor(sp.getUltimateDebtor());
            payment.setAmount(sp.getInstructedAmount().getContent());
            payment.setCurrency(sp.getInstructedAmount().getCurrency());
            payment.setCreditorIban(sp.getCreditorAccount().getIban());
            payment.setCreditorAgent(sp.getCreditorAgent());
            payment.setCreditorName(sp.getCreditorName());
            payment.setRequestedExecutionDate(sp.getRequestedExecutionDate());
            payment.setRequestedExecutionTime(sp.getRequestedExecutionTime());
            payment.setUltimateCreditor(sp.getUltimateCreditor());
            payment.setPurposeCode(sp.getPurposeCode());
            return payment;
        });
    }

    private Optional<PisConsentResponse> mapToPisConsentResponse(PisConsent pisConsent) {
        return Optional.ofNullable(pisConsent).map(pc -> new PisConsentResponse(pc.getExternalId(), pc.getPisConsentType(), pc.getConsentStatus(), this.mapToPisPayments(pc.getPayments())));
    }

    private List<PisPayment> mapToPisPayments(List<PisPaymentData> payments) {
        return payments.stream().map(pmt -> new PisPayment(pmt.getEndToEndIdentification(), pmt.getDebtorIban(), pmt.getUltimateDebtor(), pmt.getCurrency(), pmt.getAmount(), pmt.getCreditorIban(), pmt.getCreditorAgent(), pmt.getCreditorName(), pmt.getRequestedExecutionDate(), pmt.getRequestedExecutionTime(), pmt.getUltimateCreditor(), pmt.getPurposeCode())).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"pisConsentRepository"})
    public PISConsentService(PisConsentRepository pisConsentRepository) {
        this.pisConsentRepository = pisConsentRepository;
    }
}

