/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.account.AccountHolder;
import de.adorsys.aspsp.xs2a.consent.api.ActionStatus;
import de.adorsys.aspsp.xs2a.consent.api.ConsentActionRequest;
import de.adorsys.aspsp.xs2a.consent.api.TypeAccess;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisConsentRequest;
import de.adorsys.aspsp.xs2a.domain.AccountAccess;
import de.adorsys.aspsp.xs2a.domain.AisAccount;
import de.adorsys.aspsp.xs2a.domain.AisConsent;
import de.adorsys.aspsp.xs2a.domain.AisConsentAction;
import de.adorsys.aspsp.xs2a.repository.AisConsentActionRepository;
import de.adorsys.aspsp.xs2a.repository.AisConsentRepository;
import de.adorsys.aspsp.xs2a.service.AspspProfileService;
import de.adorsys.aspsp.xs2a.service.mapper.ConsentMapper;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiConsentStatus;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AISConsentService {
    private final AisConsentRepository aisConsentRepository;
    private final AisConsentActionRepository aisConsentActionRepository;
    private final ConsentMapper consentMapper;
    private final AspspProfileService profileService;

    @Transactional
    public Optional<String> createConsent(AisConsentRequest request) {
        int minFrequencyPerDay = this.profileService.getMinFrequencyPerDay(request.getFrequencyPerDay());
        AisConsent consent = new AisConsent();
        consent.setExternalId(UUID.randomUUID().toString());
        consent.setConsentStatus(SpiConsentStatus.RECEIVED);
        consent.setExpectedFrequencyPerDay(minFrequencyPerDay);
        consent.setTppFrequencyPerDay(request.getFrequencyPerDay());
        consent.setUsageCounter(minFrequencyPerDay);
        consent.setRequestDateTime(LocalDateTime.now());
        consent.setExpireDate(request.getValidUntil());
        consent.setPsuId(request.getPsuId());
        consent.setTppId(request.getTppId());
        consent.addAccounts(this.readAccounts(request.getAccess()));
        consent.setRecurringIndicator(request.isRecurringIndicator());
        consent.setTppRedirectPreferred(request.isTppRedirectPreferred());
        consent.setCombinedServiceIndicator(request.isCombinedServiceIndicator());
        AisConsent saved = (AisConsent)this.aisConsentRepository.save((Object)consent);
        return saved.getId() != null ? Optional.ofNullable(saved.getExternalId()) : Optional.empty();
    }

    private List<AisAccount> readAccounts(AisAccountAccessInfo access) {
        AccountHolder holder = new AccountHolder();
        holder.fillAccess(access.getAccounts(), TypeAccess.ACCOUNT);
        holder.fillAccess(access.getBalances(), TypeAccess.BALANCE);
        holder.fillAccess(access.getTransactions(), TypeAccess.TRANSACTION);
        return this.buildAccounts(holder.getAccountAccesses());
    }

    private List<AisAccount> buildAccounts(Map<String, Set<AccountAccess>> accountAccesses) {
        return accountAccesses.entrySet().stream().map(e -> new AisAccount((String)e.getKey(), (Set)e.getValue())).collect(Collectors.toList());
    }

    public Optional<SpiConsentStatus> getConsentStatusById(String consentId) {
        return this.getAisConsentById(consentId).map(arg_0 -> this.checkAndUpdateOnExpiration(arg_0)).map(AisConsent::getConsentStatus);
    }

    public Optional<Boolean> updateConsentStatusById(String consentId, SpiConsentStatus status) {
        return this.getActualAisConsent(consentId).map(con -> this.setStatusAndSaveConsent(con, status)).map(con -> con.getConsentStatus() == status);
    }

    public Optional<SpiAccountConsent> getSpiAccountConsentById(String consentId) {
        return this.getAisConsentById(consentId).map(arg_0 -> this.checkAndUpdateOnExpiration(arg_0)).map(arg_0 -> ((ConsentMapper)this.consentMapper).mapToSpiAccountConsent(arg_0));
    }

    @Transactional
    public void checkConsentAndSaveActionLog(ConsentActionRequest request) {
        Optional consent = this.getAisConsentById(request.getConsentId());
        this.checkAndUpdateConsentParameter(consent);
        this.logConsentAction(request.getConsentId(), this.resolveConsentActionStatus(request, consent), request.getTppId());
    }

    private void checkAndUpdateConsentParameter(Optional<AisConsent> consent) {
        if (consent.isPresent()) {
            AisConsent aisConsent = consent.get();
            this.checkAndUpdateOnExpiration(aisConsent);
            this.updateAisConsentCounter(aisConsent);
        }
    }

    private ActionStatus resolveConsentActionStatus(ConsentActionRequest request, Optional<AisConsent> consent) {
        return consent.isPresent() ? request.getActionStatus() : ActionStatus.BAD_PAYLOAD;
    }

    private void updateAisConsentCounter(AisConsent consent) {
        if (consent.hasUsagesAvailable()) {
            int usageCounter = consent.getUsageCounter();
            int newUsageCounter = --usageCounter;
            consent.setUsageCounter(newUsageCounter);
            consent.setLastActionDate(LocalDate.now());
            this.aisConsentRepository.save((Object)consent);
        }
    }

    private void logConsentAction(String requestedConsentId, ActionStatus actionStatus, String tppId) {
        AisConsentAction action = new AisConsentAction();
        action.setActionStatus(actionStatus);
        action.setRequestedConsentId(requestedConsentId);
        action.setTppId(tppId);
        action.setRequestDate(LocalDate.now());
        this.aisConsentActionRepository.save((Object)action);
    }

    private Optional<AisConsent> getActualAisConsent(String consentId) {
        return Optional.ofNullable(consentId).flatMap(c -> this.aisConsentRepository.findByExternalIdAndConsentStatusIn(consentId, EnumSet.of(SpiConsentStatus.RECEIVED, SpiConsentStatus.VALID)));
    }

    private Optional<AisConsent> getAisConsentById(String consentId) {
        return Optional.ofNullable(consentId).flatMap(arg_0 -> ((AisConsentRepository)this.aisConsentRepository).findByExternalId(arg_0));
    }

    private AisConsent checkAndUpdateOnExpiration(AisConsent consent) {
        if (consent.isExpiredByDate() && consent.isStatusNotExpired()) {
            consent.setConsentStatus(SpiConsentStatus.EXPIRED);
            consent.setExpireDate(LocalDate.now());
            consent.setLastActionDate(LocalDate.now());
            this.aisConsentRepository.save((Object)consent);
        }
        return consent;
    }

    private AisConsent setStatusAndSaveConsent(AisConsent consent, SpiConsentStatus status) {
        consent.setLastActionDate(LocalDate.now());
        consent.setConsentStatus(status);
        return (AisConsent)this.aisConsentRepository.save((Object)consent);
    }

    @ConstructorProperties(value={"aisConsentRepository", "aisConsentActionRepository", "consentMapper", "profileService"})
    public AISConsentService(AisConsentRepository aisConsentRepository, AisConsentActionRepository aisConsentActionRepository, ConsentMapper consentMapper, AspspProfileService profileService) {
        this.aisConsentRepository = aisConsentRepository;
        this.aisConsentActionRepository = aisConsentActionRepository;
        this.consentMapper = consentMapper;
        this.profileService = profileService;
    }
}

