/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Currency;
import javax.persistence.Column;
import javax.persistence.Embeddable;

@Embeddable
@ApiModel(description="pis payment entity", value="PisPaymentData")
public class PisPaymentData {
    @Column(name="end_to_end_identification")
    @ApiModelProperty(value="End to end authentication", example="RI-123456789")
    private String endToEndIdentification;
    @Column(name="debtor_iban", nullable=false)
    @ApiModelProperty(value="Iban of the debtor", required=true, example="DE2310010010123")
    private String debtorIban;
    @Column(name="ultimate_debtor", nullable=false)
    @ApiModelProperty(value="Name of the ultimate debtor", required=true, example="Mueller")
    private String ultimateDebtor;
    @Column(name="currency", nullable=false)
    @ApiModelProperty(value="Iso currency code", required=true, example="EUR")
    private Currency currency;
    @Column(name="amount", nullable=false)
    @ApiModelProperty(value="Payment amount", required=true, example="1000")
    private BigDecimal amount;
    @Column(name="creditor_iban", nullable=false)
    @ApiModelProperty(value="Iban of the creditor", required=true, example="DE2310010010123")
    private String creditorIban;
    @Column(name="creditor_agent", nullable=false)
    @ApiModelProperty(value="Creditor agent", required=true, example="Telekom")
    private String creditorAgent;
    @Column(name="creditor_name", nullable=false)
    @ApiModelProperty(value="Name of the creditor", required=true, example="Telekom")
    private String creditorName;
    @Column(name="requested_execution_date", nullable=false)
    @ApiModelProperty(value="Requested execution date", required=true, example="2017-01-01")
    private LocalDate requestedExecutionDate;
    @Column(name="requested_execution_time", nullable=false)
    @ApiModelProperty(value="Requested execution time", required=true, example="2017-10-25T15:30:35.035")
    private LocalDateTime requestedExecutionTime;
    @Column(name="ultimate_creditor")
    @ApiModelProperty(value="Ultimate creditor", example="Telekom")
    private String ultimateCreditor;
    @Column(name="purpose_code")
    @ApiModelProperty(value="Purpose code", example="BCENECEQ")
    private String purposeCode;

    public String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public String getDebtorIban() {
        return this.debtorIban;
    }

    public String getUltimateDebtor() {
        return this.ultimateDebtor;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getCreditorIban() {
        return this.creditorIban;
    }

    public String getCreditorAgent() {
        return this.creditorAgent;
    }

    public String getCreditorName() {
        return this.creditorName;
    }

    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public LocalDateTime getRequestedExecutionTime() {
        return this.requestedExecutionTime;
    }

    public String getUltimateCreditor() {
        return this.ultimateCreditor;
    }

    public String getPurposeCode() {
        return this.purposeCode;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public void setDebtorIban(String debtorIban) {
        this.debtorIban = debtorIban;
    }

    public void setUltimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setCreditorIban(String creditorIban) {
        this.creditorIban = creditorIban;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public void setRequestedExecutionTime(LocalDateTime requestedExecutionTime) {
        this.requestedExecutionTime = requestedExecutionTime;
    }

    public void setUltimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
    }

    public void setPurposeCode(String purposeCode) {
        this.purposeCode = purposeCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PisPaymentData)) {
            return false;
        }
        PisPaymentData other = (PisPaymentData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$endToEndIdentification = this.getEndToEndIdentification();
        String other$endToEndIdentification = other.getEndToEndIdentification();
        if (this$endToEndIdentification == null ? other$endToEndIdentification != null : !this$endToEndIdentification.equals(other$endToEndIdentification)) {
            return false;
        }
        String this$debtorIban = this.getDebtorIban();
        String other$debtorIban = other.getDebtorIban();
        if (this$debtorIban == null ? other$debtorIban != null : !this$debtorIban.equals(other$debtorIban)) {
            return false;
        }
        String this$ultimateDebtor = this.getUltimateDebtor();
        String other$ultimateDebtor = other.getUltimateDebtor();
        if (this$ultimateDebtor == null ? other$ultimateDebtor != null : !this$ultimateDebtor.equals(other$ultimateDebtor)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$creditorIban = this.getCreditorIban();
        String other$creditorIban = other.getCreditorIban();
        if (this$creditorIban == null ? other$creditorIban != null : !this$creditorIban.equals(other$creditorIban)) {
            return false;
        }
        String this$creditorAgent = this.getCreditorAgent();
        String other$creditorAgent = other.getCreditorAgent();
        if (this$creditorAgent == null ? other$creditorAgent != null : !this$creditorAgent.equals(other$creditorAgent)) {
            return false;
        }
        String this$creditorName = this.getCreditorName();
        String other$creditorName = other.getCreditorName();
        if (this$creditorName == null ? other$creditorName != null : !this$creditorName.equals(other$creditorName)) {
            return false;
        }
        LocalDate this$requestedExecutionDate = this.getRequestedExecutionDate();
        LocalDate other$requestedExecutionDate = other.getRequestedExecutionDate();
        if (this$requestedExecutionDate == null ? other$requestedExecutionDate != null : !((Object)this$requestedExecutionDate).equals(other$requestedExecutionDate)) {
            return false;
        }
        LocalDateTime this$requestedExecutionTime = this.getRequestedExecutionTime();
        LocalDateTime other$requestedExecutionTime = other.getRequestedExecutionTime();
        if (this$requestedExecutionTime == null ? other$requestedExecutionTime != null : !((Object)this$requestedExecutionTime).equals(other$requestedExecutionTime)) {
            return false;
        }
        String this$ultimateCreditor = this.getUltimateCreditor();
        String other$ultimateCreditor = other.getUltimateCreditor();
        if (this$ultimateCreditor == null ? other$ultimateCreditor != null : !this$ultimateCreditor.equals(other$ultimateCreditor)) {
            return false;
        }
        String this$purposeCode = this.getPurposeCode();
        String other$purposeCode = other.getPurposeCode();
        return !(this$purposeCode == null ? other$purposeCode != null : !this$purposeCode.equals(other$purposeCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PisPaymentData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endToEndIdentification = this.getEndToEndIdentification();
        result = result * 59 + ($endToEndIdentification == null ? 43 : $endToEndIdentification.hashCode());
        String $debtorIban = this.getDebtorIban();
        result = result * 59 + ($debtorIban == null ? 43 : $debtorIban.hashCode());
        String $ultimateDebtor = this.getUltimateDebtor();
        result = result * 59 + ($ultimateDebtor == null ? 43 : $ultimateDebtor.hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $creditorIban = this.getCreditorIban();
        result = result * 59 + ($creditorIban == null ? 43 : $creditorIban.hashCode());
        String $creditorAgent = this.getCreditorAgent();
        result = result * 59 + ($creditorAgent == null ? 43 : $creditorAgent.hashCode());
        String $creditorName = this.getCreditorName();
        result = result * 59 + ($creditorName == null ? 43 : $creditorName.hashCode());
        LocalDate $requestedExecutionDate = this.getRequestedExecutionDate();
        result = result * 59 + ($requestedExecutionDate == null ? 43 : ((Object)$requestedExecutionDate).hashCode());
        LocalDateTime $requestedExecutionTime = this.getRequestedExecutionTime();
        result = result * 59 + ($requestedExecutionTime == null ? 43 : ((Object)$requestedExecutionTime).hashCode());
        String $ultimateCreditor = this.getUltimateCreditor();
        result = result * 59 + ($ultimateCreditor == null ? 43 : $ultimateCreditor.hashCode());
        String $purposeCode = this.getPurposeCode();
        result = result * 59 + ($purposeCode == null ? 43 : $purposeCode.hashCode());
        return result;
    }

    public String toString() {
        return "PisPaymentData(endToEndIdentification=" + this.getEndToEndIdentification() + ", debtorIban=" + this.getDebtorIban() + ", ultimateDebtor=" + this.getUltimateDebtor() + ", currency=" + this.getCurrency() + ", amount=" + this.getAmount() + ", creditorIban=" + this.getCreditorIban() + ", creditorAgent=" + this.getCreditorAgent() + ", creditorName=" + this.getCreditorName() + ", requestedExecutionDate=" + this.getRequestedExecutionDate() + ", requestedExecutionTime=" + this.getRequestedExecutionTime() + ", ultimateCreditor=" + this.getUltimateCreditor() + ", purposeCode=" + this.getPurposeCode() + ")";
    }
}

