/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain;

import de.adorsys.aspsp.xs2a.consent.api.ActionStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;

@Entity(name="ais_consent_action")
@ApiModel(description="Ais consent action entity", value="AisConsentAction")
public class AisConsentAction {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ais_consent_action_generator")
    @SequenceGenerator(name="ais_consent_action_generator", sequenceName="ais_consent_action_id_seq")
    private Long id;
    @Column(name="request_date", nullable=false)
    @ApiModelProperty(value="Date of the last request for this consent. The content is the local ASPSP date in ISODate Format", required=true, example="2018-05-04T15:30:35.035Z")
    private LocalDate requestDate;
    @Column(name="tpp_id", nullable=false)
    @ApiModelProperty(value="TPP id", required=true, example="af006545-d713-46d7-b6cf-09c9628f9a5d")
    private String tppId;
    @Column(name="action_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="The following code values are permitted 'SUCCESS', 'BAD_PAYLOAD', 'FAILURE_ACCOUNT', 'FAILURE_BALANCE', 'FAILURE_TRANSACTION', 'FAILURE_PAYMENT'.", required=true, example="SUCCESS")
    private ActionStatus actionStatus;
    @Column(name="requested_consent_id", nullable=false)
    @ApiModelProperty(value="Requested consent ID", required=true, example="af006545-d713-46d7-b6cf-09c9628f9a5d")
    private String requestedConsentId;

    public Long getId() {
        return this.id;
    }

    public LocalDate getRequestDate() {
        return this.requestDate;
    }

    public String getTppId() {
        return this.tppId;
    }

    public ActionStatus getActionStatus() {
        return this.actionStatus;
    }

    public String getRequestedConsentId() {
        return this.requestedConsentId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setRequestDate(LocalDate requestDate) {
        this.requestDate = requestDate;
    }

    public void setTppId(String tppId) {
        this.tppId = tppId;
    }

    public void setActionStatus(ActionStatus actionStatus) {
        this.actionStatus = actionStatus;
    }

    public void setRequestedConsentId(String requestedConsentId) {
        this.requestedConsentId = requestedConsentId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AisConsentAction)) {
            return false;
        }
        AisConsentAction other = (AisConsentAction)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        LocalDate this$requestDate = this.getRequestDate();
        LocalDate other$requestDate = other.getRequestDate();
        if (this$requestDate == null ? other$requestDate != null : !((Object)this$requestDate).equals(other$requestDate)) {
            return false;
        }
        String this$tppId = this.getTppId();
        String other$tppId = other.getTppId();
        if (this$tppId == null ? other$tppId != null : !this$tppId.equals(other$tppId)) {
            return false;
        }
        ActionStatus this$actionStatus = this.getActionStatus();
        ActionStatus other$actionStatus = other.getActionStatus();
        if (this$actionStatus == null ? other$actionStatus != null : !this$actionStatus.equals(other$actionStatus)) {
            return false;
        }
        String this$requestedConsentId = this.getRequestedConsentId();
        String other$requestedConsentId = other.getRequestedConsentId();
        return !(this$requestedConsentId == null ? other$requestedConsentId != null : !this$requestedConsentId.equals(other$requestedConsentId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AisConsentAction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        LocalDate $requestDate = this.getRequestDate();
        result = result * 59 + ($requestDate == null ? 43 : ((Object)$requestDate).hashCode());
        String $tppId = this.getTppId();
        result = result * 59 + ($tppId == null ? 43 : $tppId.hashCode());
        ActionStatus $actionStatus = this.getActionStatus();
        result = result * 59 + ($actionStatus == null ? 43 : $actionStatus.hashCode());
        String $requestedConsentId = this.getRequestedConsentId();
        result = result * 59 + ($requestedConsentId == null ? 43 : $requestedConsentId.hashCode());
        return result;
    }

    public String toString() {
        return "AisConsentAction(id=" + this.getId() + ", requestDate=" + this.getRequestDate() + ", tppId=" + this.getTppId() + ", actionStatus=" + this.getActionStatus() + ", requestedConsentId=" + this.getRequestedConsentId() + ")";
    }
}

