/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.aspsp.xs2a.domain.AccountAccess;
import de.adorsys.aspsp.xs2a.domain.AisConsent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;

@Entity(name="ais_account")
@ApiModel(description="Ais account entity", value="AisAccount")
public class AisAccount {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ais_account_generator")
    @SequenceGenerator(name="ais_account_generator", sequenceName="ais_account_id_seq")
    private Long id;
    @Column(name="iban", nullable=false)
    @ApiModelProperty(value="IBAN: This data element can be used in the body of the CreateConsentReq Request Message for retrieving account access consent from this payment account", required=true, example="DE2310010010123456789")
    private String iban;
    @ElementCollection
    @CollectionTable(name="ais_account_access", joinColumns={@JoinColumn(name="account_id")})
    @ApiModelProperty(value="Set of accesses given by psu for this account", required=true)
    private List<AccountAccess> accesses = new ArrayList();
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="consent_id", nullable=false)
    @ApiModelProperty(value="Detailed information about consent", required=true)
    private AisConsent consent;

    public AisAccount() {
    }

    public AisAccount(String iban, Set<AccountAccess> accountAccesses) {
        this.iban = iban;
        this.accesses.addAll(accountAccesses);
    }

    public Long getId() {
        return this.id;
    }

    public String getIban() {
        return this.iban;
    }

    public List<AccountAccess> getAccesses() {
        return this.accesses;
    }

    public AisConsent getConsent() {
        return this.consent;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public void setAccesses(List<AccountAccess> accesses) {
        this.accesses = accesses;
    }

    public void setConsent(AisConsent consent) {
        this.consent = consent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AisAccount)) {
            return false;
        }
        AisAccount other = (AisAccount)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$iban = this.getIban();
        String other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
            return false;
        }
        List this$accesses = this.getAccesses();
        List other$accesses = other.getAccesses();
        if (this$accesses == null ? other$accesses != null : !((Object)this$accesses).equals(other$accesses)) {
            return false;
        }
        AisConsent this$consent = this.getConsent();
        AisConsent other$consent = other.getConsent();
        return !(this$consent == null ? other$consent != null : !this$consent.equals(other$consent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AisAccount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $iban = this.getIban();
        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
        List $accesses = this.getAccesses();
        result = result * 59 + ($accesses == null ? 43 : ((Object)$accesses).hashCode());
        AisConsent $consent = this.getConsent();
        result = result * 59 + ($consent == null ? 43 : $consent.hashCode());
        return result;
    }

    public String toString() {
        return "AisAccount(id=" + this.getId() + ", iban=" + this.getIban() + ", accesses=" + this.getAccesses() + ", consent=" + this.getConsent() + ")";
    }
}

