/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.account;

import de.adorsys.aspsp.xs2a.consent.api.AccountInfo;
import de.adorsys.aspsp.xs2a.consent.api.TypeAccess;
import de.adorsys.aspsp.xs2a.domain.AccountAccess;
import java.util.Currency;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public final class AccountHolder {
    private final Map<String, Set<AccountAccess>> accountAccesses = new HashMap();

    public void fillAccess(List<AccountInfo> info, TypeAccess typeAccess) {
        if (CollectionUtils.isNotEmpty(info)) {
            for (AccountInfo a : info) {
                this.addAccountAccess(a.getIban(), this.getCurrencyByString(a.getCurrency()), typeAccess);
            }
        }
    }

    private Currency getCurrencyByString(String currency) {
        return Optional.ofNullable(currency).map(Currency::getInstance).orElse(null);
    }

    private void addAccountAccess(String iban, Currency currency, TypeAccess typeAccess) {
        this.accountAccesses.putIfAbsent(iban, new HashSet());
        ((Set)this.accountAccesses.get(iban)).add(new AccountAccess(currency, typeAccess));
        if (EnumSet.of(TypeAccess.BALANCE, TypeAccess.TRANSACTION).contains(typeAccess)) {
            ((Set)this.accountAccesses.get(iban)).add(new AccountAccess(currency, TypeAccess.ACCOUNT));
        }
    }

    public Map<String, Set<AccountAccess>> getAccountAccesses() {
        return this.accountAccesses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountHolder)) {
            return false;
        }
        AccountHolder other = (AccountHolder)o;
        Map this$accountAccesses = this.getAccountAccesses();
        Map other$accountAccesses = other.getAccountAccesses();
        return !(this$accountAccesses == null ? other$accountAccesses != null : !((Object)this$accountAccesses).equals(other$accountAccesses));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $accountAccesses = this.getAccountAccesses();
        result = result * 59 + ($accountAccesses == null ? 43 : ((Object)$accountAccesses).hashCode());
        return result;
    }

    public String toString() {
        return "AccountHolder(accountAccesses=" + this.getAccountAccesses() + ")";
    }
}

