/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.cmsclient.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class HttpUriParams {
    private final Map<String, String> requestParams;
    private final Map<String, String> pathVariables;

    private HttpUriParams(Map<String, String> requestParams, Map<String, String> pathVariables) {
        this.requestParams = requestParams;
        this.pathVariables = pathVariables;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, String> getPathVariables() {
        return Collections.unmodifiableMap(this.pathVariables);
    }

    public List<NameValuePair> getRequestParams() {
        ArrayList<NameValuePair> paramsList = new ArrayList<NameValuePair>();
        for (String name : this.requestParams.keySet()) {
            paramsList.add((NameValuePair)new BasicNameValuePair(name, this.requestParams.get(name)));
        }
        return paramsList;
    }

    public static class Builder {
        private final Map<String, String> requestParams = new LinkedHashMap<String, String>();
        private final Map<String, String> pathVariables = new LinkedHashMap<String, String>();

        Builder() {
        }

        public Builder addRequestParam(String name, String value) {
            this.requestParams.put(name, value);
            return this;
        }

        public Builder addPathVariable(String name, String value) {
            this.pathVariables.put(name, value);
            return this;
        }

        public HttpUriParams build() {
            return new HttpUriParams(this.requestParams, this.pathVariables);
        }
    }
}

