/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.cmsclient.sample;

import de.adorsys.aspsp.cmsclient.cms.CmsServiceInvoker;
import de.adorsys.aspsp.cmsclient.cms.model.ais.CreateAisConsentMethod;
import de.adorsys.aspsp.cmsclient.cms.model.ais.GetAisConsentMethod;
import de.adorsys.aspsp.cmsclient.cms.model.ais.GetConsentStatusByIdMethod;
import de.adorsys.aspsp.cmsclient.cms.model.ais.SaveConsentActionLogMethod;
import de.adorsys.aspsp.cmsclient.cms.model.ais.UpdateConsentAccessMethod;
import de.adorsys.aspsp.cmsclient.cms.model.ais.UpdateConsentBlobMethod;
import de.adorsys.aspsp.cmsclient.cms.model.ais.UpdateConsentStatusMethod;
import de.adorsys.aspsp.cmsclient.cms.model.pis.CreatePaymentConsentMethod;
import de.adorsys.aspsp.cmsclient.cms.model.pis.GetPaymentConsentByIdMethod;
import de.adorsys.aspsp.cmsclient.cms.model.pis.GetPaymentConsentStatusByIdMethod;
import de.adorsys.aspsp.cmsclient.cms.model.pis.UpdatePaymentConsentStatusMethod;
import de.adorsys.aspsp.cmsclient.core.Configuration;
import de.adorsys.aspsp.cmsclient.core.util.HttpUriParams;
import de.adorsys.aspsp.xs2a.consent.api.AccountInfo;
import de.adorsys.aspsp.xs2a.consent.api.ActionStatus;
import de.adorsys.aspsp.xs2a.consent.api.AisConsentStatusResponse;
import de.adorsys.aspsp.xs2a.consent.api.CmsAccountReference;
import de.adorsys.aspsp.xs2a.consent.api.CmsAddress;
import de.adorsys.aspsp.xs2a.consent.api.CmsConsentStatus;
import de.adorsys.aspsp.xs2a.consent.api.CmsRemittance;
import de.adorsys.aspsp.xs2a.consent.api.CmsTppInfo;
import de.adorsys.aspsp.xs2a.consent.api.ConsentActionRequest;
import de.adorsys.aspsp.xs2a.consent.api.PisConsentStatusResponse;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.aspsp.xs2a.consent.api.ais.AisAccountConsent;
import de.adorsys.aspsp.xs2a.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.aspsp.xs2a.consent.api.ais.CreateAisConsentResponse;
import de.adorsys.aspsp.xs2a.consent.api.ais.UpdateAisConsentAspspDataRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisPayment;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisPaymentProduct;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisPaymentType;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.CreatePisConsentResponse;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentRequest;
import de.adorsys.aspsp.xs2a.consent.api.pis.proto.PisConsentResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Currency;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CmsExecutor {
    private static final Log logger = LogFactory.getLog(CmsExecutor.class);
    private static final String CMS_BASE_URL = "http://localhost:38080";
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int CONNECTION_REQUEST_TIMEOUT = 5000;
    private static String consentId = "Test consent id";

    public static void main(String[] args) throws IOException, URISyntaxException {
        Configuration configuration = new Configuration(CMS_BASE_URL, 5000, 5000);
        CmsServiceInvoker cmsServiceInvoker = configuration.getRestServiceInvoker();
        CmsExecutor.createAisConsent(cmsServiceInvoker);
        CmsExecutor.getAisConsentById(cmsServiceInvoker);
        CmsExecutor.getConsentStatusById(cmsServiceInvoker);
        CmsExecutor.saveConsentActionLog(cmsServiceInvoker);
        CmsExecutor.updateConsentAccess(cmsServiceInvoker);
        CmsExecutor.updateConsentBlob(cmsServiceInvoker);
        CmsExecutor.updateConsentStatus(cmsServiceInvoker);
        CmsExecutor.createPaymentConsent(cmsServiceInvoker);
        CmsExecutor.getPaymentConsentById(cmsServiceInvoker);
        CmsExecutor.getPaymentConsentStatusById(cmsServiceInvoker);
        CmsExecutor.updatePaymentConsentStatus(cmsServiceInvoker);
    }

    private static void createAisConsent(CmsServiceInvoker cmsServiceInvoker) throws IOException, URISyntaxException {
        Optional<CreateAisConsentResponse> createAisResponse = Optional.ofNullable(cmsServiceInvoker.invoke(new CreateAisConsentMethod(CmsExecutor.buildAisConsentRequest())));
        createAisResponse.ifPresent(resp -> {
            consentId = resp.getConsentId();
        });
        logger.info((Object)("Consent ID: " + consentId));
    }

    private static void getAisConsentById(CmsServiceInvoker cmsServiceInvoker) throws IOException, URISyntaxException {
        HttpUriParams uriParams = HttpUriParams.builder().addPathVariable("consent-id", consentId).build();
        Optional<AisAccountConsent> aisAccountConsent = Optional.ofNullable(cmsServiceInvoker.invoke(new GetAisConsentMethod(uriParams)));
        aisAccountConsent.ifPresent(consent -> logger.info((Object)("Ais account consent status: " + consent.getConsentStatus())));
    }

    private static void saveConsentActionLog(CmsServiceInvoker cmsServiceInvoker) throws IOException, URISyntaxException {
        cmsServiceInvoker.invoke(new SaveConsentActionLogMethod(new ConsentActionRequest("tpp-id", consentId, ActionStatus.SUCCESS)));
    }

    private static void getConsentStatusById(CmsServiceInvoker cmsServiceInvoker) throws IOException, URISyntaxException {
        HttpUriParams uriParams = HttpUriParams.builder().addPathVariable("consent-id", consentId).build();
        Optional<AisConsentStatusResponse> consentStatusResponse = Optional.ofNullable(cmsServiceInvoker.invoke(new GetConsentStatusByIdMethod(uriParams)));
        consentStatusResponse.ifPresent(status -> logger.info((Object)("Status of the consent: " + status.getConsentStatus().name())));
    }

    private static void updateConsentAccess(CmsServiceInvoker cmsServiceInvoker) throws IOException, URISyntaxException {
        HttpUriParams uriParams = HttpUriParams.builder().addPathVariable("consent-id", consentId).build();
        Optional<CreateAisConsentResponse> updateAccessResponse = Optional.ofNullable(cmsServiceInvoker.invoke(new UpdateConsentAccessMethod(CmsExecutor.buildAccess(), uriParams)));
        updateAccessResponse.ifPresent(resp -> logger.info((Object)("Access was updated in: " + resp.getConsentId())));
    }

    private static void updateConsentBlob(CmsServiceInvoker cmsServiceInvoker) throws IOException, URISyntaxException {
        HttpUriParams uriParams = HttpUriParams.builder().addPathVariable("consent-id", consentId).build();
        Optional<CreateAisConsentResponse> updateBlobResponse = Optional.ofNullable(cmsServiceInvoker.invoke(new UpdateConsentBlobMethod(CmsExecutor.buildUpdateBlobRequest(), uriParams)));
        updateBlobResponse.ifPresent(resp -> logger.info((Object)("Blob was updated in: " + resp.getConsentId())));
    }

    private static void updateConsentStatus(CmsServiceInvoker cmsServiceInvoker) throws IOException, URISyntaxException {
        HttpUriParams uriParams = HttpUriParams.builder().addPathVariable("consent-id", consentId).addPathVariable("status", CmsConsentStatus.REVOKED_BY_PSU.name()).build();
        cmsServiceInvoker.invoke(new UpdateConsentStatusMethod(uriParams));
    }

    private static CreateAisConsentRequest buildAisConsentRequest() {
        CreateAisConsentRequest request = new CreateAisConsentRequest();
        request.setAccess(CmsExecutor.buildAccess());
        request.setCombinedServiceIndicator(true);
        request.setFrequencyPerDay(10);
        request.setPsuId("psu-id-1");
        request.setRecurringIndicator(true);
        request.setTppId("tpp-id-1");
        request.setValidUntil(LocalDate.of(2020, 12, 31));
        request.setTppRedirectPreferred(true);
        return request;
    }

    private static AisAccountAccessInfo buildAccess() {
        AisAccountAccessInfo info = new AisAccountAccessInfo();
        info.setAccounts(Collections.singletonList(new AccountInfo("iban-1", "EUR")));
        return info;
    }

    private static UpdateAisConsentAspspDataRequest buildUpdateBlobRequest() {
        UpdateAisConsentAspspDataRequest request = new UpdateAisConsentAspspDataRequest();
        request.setAspspConsentData("zdxcvvzzzxcvzzzz".getBytes());
        return request;
    }

    private static void createPaymentConsent(CmsServiceInvoker cmsServiceInvoker) throws IOException, URISyntaxException {
        Optional<CreatePisConsentResponse> createPisResponse = Optional.ofNullable(cmsServiceInvoker.invoke(new CreatePaymentConsentMethod(CmsExecutor.buildPisConsentRequest())));
        createPisResponse.ifPresent(resp -> {
            consentId = resp.getConsentId();
        });
        logger.info((Object)("Consent ID: " + consentId));
    }

    private static void getPaymentConsentById(CmsServiceInvoker cmsServiceInvoker) throws IOException, URISyntaxException {
        HttpUriParams uriParams = HttpUriParams.builder().addPathVariable("consent-id", consentId).build();
        Optional<PisConsentResponse> pisAccountConsent = Optional.ofNullable(cmsServiceInvoker.invoke(new GetPaymentConsentByIdMethod(uriParams)));
        pisAccountConsent.ifPresent(consent -> logger.info((Object)("Pis account consent status: " + consent.getConsentStatus())));
    }

    private static void getPaymentConsentStatusById(CmsServiceInvoker cmsServiceInvoker) throws IOException, URISyntaxException {
        HttpUriParams uriParams = HttpUriParams.builder().addPathVariable("consent-id", consentId).build();
        Optional<PisConsentStatusResponse> consentStatusResponse = Optional.ofNullable(cmsServiceInvoker.invoke(new GetPaymentConsentStatusByIdMethod(uriParams)));
        consentStatusResponse.ifPresent(response -> logger.info((Object)("Status of the consent: " + response.getConsentStatus().name())));
    }

    private static void updatePaymentConsentStatus(CmsServiceInvoker cmsServiceInvoker) throws IOException, URISyntaxException {
        HttpUriParams uriParams = HttpUriParams.builder().addPathVariable("consent-id", consentId).addPathVariable("status", CmsConsentStatus.REVOKED_BY_PSU.name()).build();
        cmsServiceInvoker.invoke(new UpdatePaymentConsentStatusMethod(uriParams));
    }

    private static PisConsentRequest buildPisConsentRequest() {
        PisConsentRequest request = new PisConsentRequest();
        request.setPayments(Collections.singletonList(CmsExecutor.buildPisPayment()));
        request.setPaymentProduct(PisPaymentProduct.SCT);
        request.setPaymentType(PisPaymentType.SINGLE);
        request.setTppInfo(CmsExecutor.buildCmsTppInfo("1234_registrationNumber", "Tpp company", "Tpp role", "National competent authority", "Redirect URI", "Nok redirect URI"));
        request.setAspspConsentData("zzzzzzzz".getBytes());
        return request;
    }

    private static PisPayment buildPisPayment() {
        PisPayment payment = new PisPayment();
        payment.setPaymentId("32454656712432");
        payment.setEndToEndIdentification("RI-123456789");
        payment.setDebtorAccount(new CmsAccountReference("DE89370400440532013000", "89370400440532010000", "2356 5746 3217 1234", "2356xxxxxx1234", "+49(0)911 360698-0", Currency.getInstance("EUR")));
        payment.setUltimateDebtor("Mueller");
        payment.setCurrency(Currency.getInstance("EUR"));
        payment.setAmount(BigDecimal.valueOf(1000L));
        payment.setCreditorAccount(new CmsAccountReference("DE89370400440532013000", "89370400440532010000", "2356 5746 3217 1234", "2356xxxxxx1234", "+49(0)911 360698-0", Currency.getInstance("EUR")));
        payment.setCreditorAgent("Telekom");
        payment.setCreditorName("Telekom");
        payment.setCreditorAddress(CmsExecutor.buildCmsAddress("Herrnstra\u00dfe", "123-34", "N\u00fcrnberg", "90431", "Germany"));
        payment.setRemittanceInformationUnstructured("Ref. Number TELEKOM-1222");
        payment.setRemittanceInformationStructured(CmsExecutor.buildCmsRemittance("Ref Number Merchant", "reference type", "reference issuer"));
        payment.setRequestedExecutionDate(LocalDate.of(2020, 1, 1));
        payment.setRequestedExecutionTime(LocalDateTime.parse("2020-01-01T15:30:35.035Z", DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")));
        payment.setUltimateCreditor("Telekom");
        payment.setPurposeCode("BCENECEQ");
        payment.setStartDate(LocalDate.of(2020, 1, 1));
        payment.setEndDate(LocalDate.of(2020, 3, 3));
        payment.setExecutionRule("latest");
        payment.setFrequency("ANNUAL");
        payment.setDayOfExecution(14);
        return payment;
    }

    private static CmsAddress buildCmsAddress(String street, String buildingNumber, String city, String postalCode, String country) {
        CmsAddress address = new CmsAddress();
        address.setStreet(street);
        address.setBuildingNumber(buildingNumber);
        address.setCity(city);
        address.setPostalCode(postalCode);
        address.setCountry(country);
        return address;
    }

    private static CmsRemittance buildCmsRemittance(String reference, String referenceType, String referenceIssuer) {
        CmsRemittance remittance = new CmsRemittance();
        remittance.setReference(reference);
        remittance.setReferenceType(referenceType);
        remittance.setReferenceIssuer(referenceIssuer);
        return remittance;
    }

    private static CmsTppInfo buildCmsTppInfo(String registrationNumber, String tppName, String tppRole, String nationalCompetentAuthority, String redirectUri, String nokRedirectUri) {
        CmsTppInfo tppInfo = new CmsTppInfo();
        tppInfo.setRegistrationNumber(registrationNumber);
        tppInfo.setTppName(tppName);
        tppInfo.setTppRole(tppRole);
        tppInfo.setNationalCompetentAuthority(nationalCompetentAuthority);
        tppInfo.setRedirectUri(redirectUri);
        tppInfo.setNokRedirectUri(nokRedirectUri);
        return tppInfo;
    }
}

