/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.cmsclient.core.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ObjectMapperUtil {
    private static final Log logger = LogFactory.getLog(ObjectMapperUtil.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    private ObjectMapperUtil() {
    }

    public static <T> Optional<String> toJson(T object) {
        try {
            return object == null ? Optional.empty() : Optional.ofNullable(mapper.writeValueAsString(object));
        }
        catch (JsonProcessingException e) {
            logger.error((Object)"Can't convert object to json");
            return Optional.empty();
        }
    }

    public static <T> Optional<T> toObject(String json, Class<T> target) {
        try {
            return json == null || json.equals("") ? Optional.empty() : Optional.ofNullable(mapper.readValue(json, target));
        }
        catch (IOException e) {
            logger.error((Object)"Can't convert json to object");
            return Optional.empty();
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.registerModule((Module)new Jdk8Module());
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)new ParameterNamesModule());
    }
}

