/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.cmsclient.core;

import de.adorsys.aspsp.cmsclient.core.util.ObjectMapperUtil;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;

public class CommonResponseHandler<R>
implements ResponseHandler<R> {
    private static final Log logger = LogFactory.getLog(CommonResponseHandler.class);
    private final Class<R> responseClass;

    public CommonResponseHandler(Class<R> responseClass) {
        this.responseClass = responseClass;
    }

    public R handleResponse(HttpResponse response) throws IOException {
        int status = response.getStatusLine().getStatusCode();
        logger.info((Object)("Http status: " + status));
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            String asString = null;
            if (entity != null) {
                asString = EntityUtils.toString((HttpEntity)entity);
            }
            logger.info((Object)("body: " + asString));
            return ObjectMapperUtil.toObject(asString, this.responseClass).orElse(null);
        }
        throw new ClientProtocolException("Unexpected response status: " + status);
    }
}

