/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.cmsclient.core;

import de.adorsys.aspsp.cmsclient.core.CommonResponseHandler;
import de.adorsys.aspsp.cmsclient.core.HttpMethod;
import de.adorsys.aspsp.cmsclient.core.RestClientConfig;
import de.adorsys.aspsp.cmsclient.core.RestRequestMethod;
import de.adorsys.aspsp.cmsclient.core.util.HttpUriParams;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public abstract class AbstractServiceInvoker {
    private final RestClientConfig restClientConfig;

    protected AbstractServiceInvoker(RestClientConfig restClientConfig) {
        this.restClientConfig = restClientConfig;
    }

    public <T, R> R invoke(RestRequestMethod<T, R> restRequestMethod) throws IOException, URISyntaxException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            Object object = httpClient.execute((HttpUriRequest)this.buildHttpRequestBase(restRequestMethod), new CommonResponseHandler<R>(restRequestMethod.responseClass()));
            return (R)object;
        }
    }

    private <T, R> HttpRequestBase buildHttpRequestBase(RestRequestMethod<T, R> restRequestMethod) throws URISyntaxException {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.restClientConfig.getConnectTimeout()).setConnectionRequestTimeout(this.restClientConfig.getConnectionRequestTimeout()).build();
        HttpMethod httpMethod = restRequestMethod.httpMethod();
        T requestBody = restRequestMethod.requestBody();
        HttpRequestBase requestBase = requestBody != null ? httpMethod.getHttpRequest(requestBody) : httpMethod.getHttpRequest();
        requestBase.setConfig(requestConfig);
        requestBase.setURI(this.buildFullPath(restRequestMethod));
        restRequestMethod.headers().forEach(arg_0 -> ((HttpRequestBase)requestBase).addHeader(arg_0));
        return requestBase;
    }

    private <T, R> URI buildFullPath(RestRequestMethod<T, R> restMethod) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(this.restClientConfig.getBaseServiceUrl()).setPath(this.enrichPathVariable(restMethod));
        HttpUriParams uriParams = restMethod.uriParams();
        if (uriParams != null) {
            uriBuilder.addParameters(uriParams.getRequestParams());
        }
        return uriBuilder.build();
    }

    private <T, R> String enrichPathVariable(RestRequestMethod<T, R> restMethod) {
        String path = restMethod.path();
        HttpUriParams uriParams = restMethod.uriParams();
        if (uriParams != null) {
            Map<String, String> pathVariableValues = uriParams.getPathVariables();
            Pattern pattern = Pattern.compile("\\{(.+?)}");
            Matcher matcher = pattern.matcher(path);
            while (matcher.find()) {
                String pathVariableNameWithoutBrackets = matcher.group(1);
                if (!pathVariableValues.containsKey(pathVariableNameWithoutBrackets)) {
                    throw new IllegalArgumentException("Path variable name not found in parameter map");
                }
                String pathVariableName = matcher.group();
                path = path.replaceFirst(Pattern.quote(pathVariableName), pathVariableValues.get(pathVariableNameWithoutBrackets));
            }
        }
        return path;
    }
}

