/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.cmsclient.core;

import de.adorsys.aspsp.cmsclient.core.HttpMethod;
import de.adorsys.aspsp.cmsclient.core.RestRequestMethod;
import de.adorsys.aspsp.cmsclient.core.util.HttpUriParams;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public abstract class AbstractRequestMethod<T, R>
implements RestRequestMethod<T, R> {
    private final Class<R> responseClass;
    private final T requestObject;
    private final HttpMethod httpMethod;
    private final String path;
    private HttpUriParams uriParams;

    public AbstractRequestMethod(T requestObject, HttpMethod httpMethod, String path) {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.responseClass = (Class)genericSuperclass.getActualTypeArguments()[1];
        this.requestObject = requestObject;
        this.httpMethod = httpMethod;
        this.path = path;
    }

    public AbstractRequestMethod(T requestObject, HttpMethod httpMethod, String path, HttpUriParams uriParams) {
        this(requestObject, httpMethod, path);
        this.uriParams = uriParams;
    }

    public AbstractRequestMethod(HttpMethod httpMethod, String path, HttpUriParams uriParams) {
        this(null, httpMethod, path);
        this.uriParams = uriParams;
    }

    @Override
    public Class<R> responseClass() {
        return this.responseClass;
    }

    @Override
    public T requestBody() {
        return this.requestObject;
    }

    @Override
    public HttpMethod httpMethod() {
        return this.httpMethod;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public List<Header> headers() {
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add((Header)new BasicHeader("Accept", "application/json"));
        headers.add((Header)new BasicHeader("Content-Type", "application/json"));
        return headers;
    }

    @Override
    public HttpUriParams uriParams() {
        return this.uriParams;
    }
}

