/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.cmsclient.core.util;

import de.adorsys.aspsp.cmsclient.core.util.ObjectMapperUtil;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.entity.StringEntity;

public final class StringEntityUtil {
    private static final Log logger = LogFactory.getLog(StringEntityUtil.class);

    private StringEntityUtil() {
    }

    public static <R> Optional<StringEntity> buildStringEntity(R requestBody) {
        try {
            String asJson = ObjectMapperUtil.toJson(requestBody).orElse("");
            return Optional.of(new StringEntity(asJson, StandardCharsets.UTF_8));
        }
        catch (UnsupportedCharsetException e) {
            logger.error((Object)"Can't convert object to StringEntity");
            return Optional.empty();
        }
    }
}

