/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.config.ProfileConfiguration;
import de.adorsys.aspsp.xs2a.domain.AspspSettings;
import de.adorsys.aspsp.xs2a.domain.AuthorisationStartType;
import de.adorsys.aspsp.xs2a.domain.BookingStatus;
import de.adorsys.aspsp.xs2a.domain.MulticurrencyAccountLevel;
import de.adorsys.aspsp.xs2a.domain.ScaApproach;
import de.adorsys.aspsp.xs2a.domain.SupportedAccountReferenceField;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class AspspProfileService {
    private final ProfileConfiguration profileConfiguration;

    public AspspSettings getAspspSettings() {
        return new AspspSettings(this.profileConfiguration.getFrequencyPerDay(), this.profileConfiguration.isCombinedServiceIndicator(), this.profileConfiguration.getAvailablePaymentProducts(), this.profileConfiguration.getAvailablePaymentTypes(), this.profileConfiguration.isTppSignatureRequired(), this.profileConfiguration.getPisRedirectUrlToAspsp(), this.profileConfiguration.getAisRedirectUrlToAspsp(), this.profileConfiguration.getMulticurrencyAccountLevel(), this.profileConfiguration.isBankOfferedConsentSupport(), this.profileConfiguration.getAvailableBookingStatuses(), this.profileConfiguration.getSupportedAccountReferenceFields(), this.profileConfiguration.getConsentLifetime(), this.profileConfiguration.getTransactionLifetime(), this.profileConfiguration.isAllPsd2Support(), this.profileConfiguration.getAuthorisationStartType());
    }

    public ScaApproach getScaApproach() {
        return this.profileConfiguration.getScaApproach();
    }

    public void updateFrequencyPerDay(int frequencyPerDay) {
        this.profileConfiguration.setFrequencyPerDay(frequencyPerDay);
    }

    public void updateCombinedServiceIndicator(boolean combinedServiceIndicator) {
        this.profileConfiguration.setCombinedServiceIndicator(combinedServiceIndicator);
    }

    public void updateBankOfferedConsentSupport(boolean bankOfferedConsentSupport) {
        this.profileConfiguration.setBankOfferedConsentSupport(bankOfferedConsentSupport);
    }

    public void updateAvailablePaymentProducts(List<String> availablePaymentProducts) {
        this.profileConfiguration.setAvailablePaymentProducts(availablePaymentProducts);
    }

    public void updateAvailablePaymentTypes(List<String> availablePaymentTypes) {
        this.profileConfiguration.setAvailablePaymentTypes(availablePaymentTypes);
    }

    public void updateScaApproach(ScaApproach scaApproach) {
        this.profileConfiguration.setScaApproach(scaApproach);
    }

    public void updateTppSignatureRequired(boolean tppSignatureRequired) {
        this.profileConfiguration.setTppSignatureRequired(tppSignatureRequired);
    }

    public void updatePisRedirectUrlToAspsp(String redirectUrlToAspsp) {
        this.profileConfiguration.setPisRedirectUrlToAspsp(redirectUrlToAspsp);
    }

    public void updateAisRedirectUrlToAspsp(String redirectUrlToAspsp) {
        this.profileConfiguration.setAisRedirectUrlToAspsp(redirectUrlToAspsp);
    }

    public void updateMulticurrencyAccountLevel(MulticurrencyAccountLevel multicurrencyAccountLevel) {
        this.profileConfiguration.setMulticurrencyAccountLevel(multicurrencyAccountLevel);
    }

    public void updateAvailableBookingStatuses(List<BookingStatus> availableBookingStatuses) {
        if (!availableBookingStatuses.contains(BookingStatus.BOOKED)) {
            availableBookingStatuses.add(BookingStatus.BOOKED);
        }
        this.profileConfiguration.setAvailableBookingStatuses(availableBookingStatuses);
    }

    public void updateSupportedAccountReferenceFields(List<SupportedAccountReferenceField> fields) {
        if (!fields.contains(SupportedAccountReferenceField.IBAN)) {
            fields.add(SupportedAccountReferenceField.IBAN);
        }
        this.profileConfiguration.setSupportedAccountReferenceFields(fields);
    }

    public void updateConsentLifetime(int consentLifetime) {
        this.profileConfiguration.setConsentLifetime(consentLifetime);
    }

    public void updateTransactionLifetime(int transactionLifetime) {
        this.profileConfiguration.setTransactionLifetime(transactionLifetime);
    }

    public void updateAllPsd2Support(boolean allPsd2Support) {
        this.profileConfiguration.setAllPsd2Support(allPsd2Support);
    }

    public void updateAuthorisationStartType(AuthorisationStartType authorisationStartType) {
        this.profileConfiguration.setAuthorisationStartType(authorisationStartType);
    }

    @ConstructorProperties(value={"profileConfiguration"})
    public AspspProfileService(ProfileConfiguration profileConfiguration) {
        this.profileConfiguration = profileConfiguration;
    }
}

