/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.domain;

import de.adorsys.aspsp.xs2a.domain.AuthorisationStartType;
import de.adorsys.aspsp.xs2a.domain.BookingStatus;
import de.adorsys.aspsp.xs2a.domain.MulticurrencyAccountLevel;
import de.adorsys.aspsp.xs2a.domain.SupportedAccountReferenceField;
import java.beans.ConstructorProperties;
import java.util.List;

public final class AspspSettings {
    private final int frequencyPerDay;
    private final boolean combinedServiceIndicator;
    private final List<String> availablePaymentProducts;
    private final List<String> availablePaymentTypes;
    private final boolean tppSignatureRequired;
    private final String pisRedirectUrlToAspsp;
    private final String aisRedirectUrlToAspsp;
    private final MulticurrencyAccountLevel multicurrencyAccountLevel;
    private final boolean bankOfferedConsentSupport;
    private final List<BookingStatus> availableBookingStatuses;
    private final List<SupportedAccountReferenceField> supportedAccountReferenceFields;
    private final int consentLifetime;
    private final int transactionLifetime;
    private final boolean allPsd2Support;
    private final AuthorisationStartType authorisationStartType;

    @ConstructorProperties(value={"frequencyPerDay", "combinedServiceIndicator", "availablePaymentProducts", "availablePaymentTypes", "tppSignatureRequired", "pisRedirectUrlToAspsp", "aisRedirectUrlToAspsp", "multicurrencyAccountLevel", "bankOfferedConsentSupport", "availableBookingStatuses", "supportedAccountReferenceFields", "consentLifetime", "transactionLifetime", "allPsd2Support", "authorisationStartType"})
    public AspspSettings(int frequencyPerDay, boolean combinedServiceIndicator, List<String> availablePaymentProducts, List<String> availablePaymentTypes, boolean tppSignatureRequired, String pisRedirectUrlToAspsp, String aisRedirectUrlToAspsp, MulticurrencyAccountLevel multicurrencyAccountLevel, boolean bankOfferedConsentSupport, List<BookingStatus> availableBookingStatuses, List<SupportedAccountReferenceField> supportedAccountReferenceFields, int consentLifetime, int transactionLifetime, boolean allPsd2Support, AuthorisationStartType authorisationStartType) {
        this.frequencyPerDay = frequencyPerDay;
        this.combinedServiceIndicator = combinedServiceIndicator;
        this.availablePaymentProducts = availablePaymentProducts;
        this.availablePaymentTypes = availablePaymentTypes;
        this.tppSignatureRequired = tppSignatureRequired;
        this.pisRedirectUrlToAspsp = pisRedirectUrlToAspsp;
        this.aisRedirectUrlToAspsp = aisRedirectUrlToAspsp;
        this.multicurrencyAccountLevel = multicurrencyAccountLevel;
        this.bankOfferedConsentSupport = bankOfferedConsentSupport;
        this.availableBookingStatuses = availableBookingStatuses;
        this.supportedAccountReferenceFields = supportedAccountReferenceFields;
        this.consentLifetime = consentLifetime;
        this.transactionLifetime = transactionLifetime;
        this.allPsd2Support = allPsd2Support;
        this.authorisationStartType = authorisationStartType;
    }

    public int getFrequencyPerDay() {
        return this.frequencyPerDay;
    }

    public boolean isCombinedServiceIndicator() {
        return this.combinedServiceIndicator;
    }

    public List<String> getAvailablePaymentProducts() {
        return this.availablePaymentProducts;
    }

    public List<String> getAvailablePaymentTypes() {
        return this.availablePaymentTypes;
    }

    public boolean isTppSignatureRequired() {
        return this.tppSignatureRequired;
    }

    public String getPisRedirectUrlToAspsp() {
        return this.pisRedirectUrlToAspsp;
    }

    public String getAisRedirectUrlToAspsp() {
        return this.aisRedirectUrlToAspsp;
    }

    public MulticurrencyAccountLevel getMulticurrencyAccountLevel() {
        return this.multicurrencyAccountLevel;
    }

    public boolean isBankOfferedConsentSupport() {
        return this.bankOfferedConsentSupport;
    }

    public List<BookingStatus> getAvailableBookingStatuses() {
        return this.availableBookingStatuses;
    }

    public List<SupportedAccountReferenceField> getSupportedAccountReferenceFields() {
        return this.supportedAccountReferenceFields;
    }

    public int getConsentLifetime() {
        return this.consentLifetime;
    }

    public int getTransactionLifetime() {
        return this.transactionLifetime;
    }

    public boolean isAllPsd2Support() {
        return this.allPsd2Support;
    }

    public AuthorisationStartType getAuthorisationStartType() {
        return this.authorisationStartType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AspspSettings)) {
            return false;
        }
        AspspSettings other = (AspspSettings)o;
        if (this.getFrequencyPerDay() != other.getFrequencyPerDay()) {
            return false;
        }
        if (this.isCombinedServiceIndicator() != other.isCombinedServiceIndicator()) {
            return false;
        }
        List this$availablePaymentProducts = this.getAvailablePaymentProducts();
        List other$availablePaymentProducts = other.getAvailablePaymentProducts();
        if (this$availablePaymentProducts == null ? other$availablePaymentProducts != null : !((Object)this$availablePaymentProducts).equals(other$availablePaymentProducts)) {
            return false;
        }
        List this$availablePaymentTypes = this.getAvailablePaymentTypes();
        List other$availablePaymentTypes = other.getAvailablePaymentTypes();
        if (this$availablePaymentTypes == null ? other$availablePaymentTypes != null : !((Object)this$availablePaymentTypes).equals(other$availablePaymentTypes)) {
            return false;
        }
        if (this.isTppSignatureRequired() != other.isTppSignatureRequired()) {
            return false;
        }
        String this$pisRedirectUrlToAspsp = this.getPisRedirectUrlToAspsp();
        String other$pisRedirectUrlToAspsp = other.getPisRedirectUrlToAspsp();
        if (this$pisRedirectUrlToAspsp == null ? other$pisRedirectUrlToAspsp != null : !this$pisRedirectUrlToAspsp.equals(other$pisRedirectUrlToAspsp)) {
            return false;
        }
        String this$aisRedirectUrlToAspsp = this.getAisRedirectUrlToAspsp();
        String other$aisRedirectUrlToAspsp = other.getAisRedirectUrlToAspsp();
        if (this$aisRedirectUrlToAspsp == null ? other$aisRedirectUrlToAspsp != null : !this$aisRedirectUrlToAspsp.equals(other$aisRedirectUrlToAspsp)) {
            return false;
        }
        MulticurrencyAccountLevel this$multicurrencyAccountLevel = this.getMulticurrencyAccountLevel();
        MulticurrencyAccountLevel other$multicurrencyAccountLevel = other.getMulticurrencyAccountLevel();
        if (this$multicurrencyAccountLevel == null ? other$multicurrencyAccountLevel != null : !this$multicurrencyAccountLevel.equals(other$multicurrencyAccountLevel)) {
            return false;
        }
        if (this.isBankOfferedConsentSupport() != other.isBankOfferedConsentSupport()) {
            return false;
        }
        List this$availableBookingStatuses = this.getAvailableBookingStatuses();
        List other$availableBookingStatuses = other.getAvailableBookingStatuses();
        if (this$availableBookingStatuses == null ? other$availableBookingStatuses != null : !((Object)this$availableBookingStatuses).equals(other$availableBookingStatuses)) {
            return false;
        }
        List this$supportedAccountReferenceFields = this.getSupportedAccountReferenceFields();
        List other$supportedAccountReferenceFields = other.getSupportedAccountReferenceFields();
        if (this$supportedAccountReferenceFields == null ? other$supportedAccountReferenceFields != null : !((Object)this$supportedAccountReferenceFields).equals(other$supportedAccountReferenceFields)) {
            return false;
        }
        if (this.getConsentLifetime() != other.getConsentLifetime()) {
            return false;
        }
        if (this.getTransactionLifetime() != other.getTransactionLifetime()) {
            return false;
        }
        if (this.isAllPsd2Support() != other.isAllPsd2Support()) {
            return false;
        }
        AuthorisationStartType this$authorisationStartType = this.getAuthorisationStartType();
        AuthorisationStartType other$authorisationStartType = other.getAuthorisationStartType();
        return !(this$authorisationStartType == null ? other$authorisationStartType != null : !this$authorisationStartType.equals(other$authorisationStartType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFrequencyPerDay();
        result = result * 59 + (this.isCombinedServiceIndicator() ? 79 : 97);
        List $availablePaymentProducts = this.getAvailablePaymentProducts();
        result = result * 59 + ($availablePaymentProducts == null ? 43 : ((Object)$availablePaymentProducts).hashCode());
        List $availablePaymentTypes = this.getAvailablePaymentTypes();
        result = result * 59 + ($availablePaymentTypes == null ? 43 : ((Object)$availablePaymentTypes).hashCode());
        result = result * 59 + (this.isTppSignatureRequired() ? 79 : 97);
        String $pisRedirectUrlToAspsp = this.getPisRedirectUrlToAspsp();
        result = result * 59 + ($pisRedirectUrlToAspsp == null ? 43 : $pisRedirectUrlToAspsp.hashCode());
        String $aisRedirectUrlToAspsp = this.getAisRedirectUrlToAspsp();
        result = result * 59 + ($aisRedirectUrlToAspsp == null ? 43 : $aisRedirectUrlToAspsp.hashCode());
        MulticurrencyAccountLevel $multicurrencyAccountLevel = this.getMulticurrencyAccountLevel();
        result = result * 59 + ($multicurrencyAccountLevel == null ? 43 : $multicurrencyAccountLevel.hashCode());
        result = result * 59 + (this.isBankOfferedConsentSupport() ? 79 : 97);
        List $availableBookingStatuses = this.getAvailableBookingStatuses();
        result = result * 59 + ($availableBookingStatuses == null ? 43 : ((Object)$availableBookingStatuses).hashCode());
        List $supportedAccountReferenceFields = this.getSupportedAccountReferenceFields();
        result = result * 59 + ($supportedAccountReferenceFields == null ? 43 : ((Object)$supportedAccountReferenceFields).hashCode());
        result = result * 59 + this.getConsentLifetime();
        result = result * 59 + this.getTransactionLifetime();
        result = result * 59 + (this.isAllPsd2Support() ? 79 : 97);
        AuthorisationStartType $authorisationStartType = this.getAuthorisationStartType();
        result = result * 59 + ($authorisationStartType == null ? 43 : $authorisationStartType.hashCode());
        return result;
    }

    public String toString() {
        return "AspspSettings(frequencyPerDay=" + this.getFrequencyPerDay() + ", combinedServiceIndicator=" + this.isCombinedServiceIndicator() + ", availablePaymentProducts=" + this.getAvailablePaymentProducts() + ", availablePaymentTypes=" + this.getAvailablePaymentTypes() + ", tppSignatureRequired=" + this.isTppSignatureRequired() + ", pisRedirectUrlToAspsp=" + this.getPisRedirectUrlToAspsp() + ", aisRedirectUrlToAspsp=" + this.getAisRedirectUrlToAspsp() + ", multicurrencyAccountLevel=" + this.getMulticurrencyAccountLevel() + ", bankOfferedConsentSupport=" + this.isBankOfferedConsentSupport() + ", availableBookingStatuses=" + this.getAvailableBookingStatuses() + ", supportedAccountReferenceFields=" + this.getSupportedAccountReferenceFields() + ", consentLifetime=" + this.getConsentLifetime() + ", transactionLifetime=" + this.getTransactionLifetime() + ", allPsd2Support=" + this.isAllPsd2Support() + ", authorisationStartType=" + this.getAuthorisationStartType() + ")";
    }
}

